var module_list = (function($) {
    'use strict';

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }

    function user_saml_onclick_generate(qlist, elems)
    {
        var mkey = qlist_get_row_attr(elems, 'mkey');
        if (mkey) {
            var $iframe = $j('<iframe id="download-file-iframe" />');
            var $form = $j('<form target="download-file-iframe" method="POST" action="/user/saml_user/generate" />');
            $form.append('<input type="hidden" name="mkey" value="' + mkey + '" />');
            $form.append('<input type="hidden" name="session_id" value="' + session_id + '" />');
            $iframe.append($form);
            $j(document.body).append($iframe);
            $form[0].submit();
            $iframe.remove();
        }
    }

    function user_saml_handle_selection_change(qlist) {
        qlist_handle_selection_change(qlist);
        if (is_rw_admin) {
            var mi_generate = $('#mi_generate_' + qlist.prefix);
            var aElems = qlist.get_checked_rows();
            if (aElems.length == 1)
                qmenu_enable_button(mi_generate, true, qlist);
            else
                qmenu_enable_button(mi_generate, false, qlist);
        }
    }

    function gen_qlist(datas) {
        var menu_items = {};
        if (is_rw_admin) {
            menu_items = {
                'mi_generate': {
                    'id': 'mi_generate',
                    'label': $.getInfo('generate', flt_lang),
                    'class': 'tool_clone',
                    'handler': user_saml_onclick_generate
                }
            };
        }
        var settings = {
            'prefix': 'user_saml_list',
            'source': datas,
            'menu_items': menu_items,
            'handle_selection_change': user_saml_handle_selection_change,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'columns': [
                {'selector': 'id', 'lang_key': '#'},
                {'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
                {'selector': 'entityID', 'lang_key': $j.getInfo('entity_id', flt_lang) },
                {'selector': 'service-path', 'lang_key': $j.getInfo('service_path', flt_lang) },
            ],
            'column_filters': {
                'enabled': false
            },
            'options': {
                'ref_column': false,
                'sorting': false
            },
            'default_columns': ['id', 'name', 'entityID', 'service-path'],
            'row_attr': [
                { name: 'mkey', selector: 'name' },
                { name: 'q_ref', selector: 'q_ref' },
            ],
            'callbacks': {
                'load': content_loaded
            }
        };

        var $container = $("#content");
        $container.qlist(settings);
    }

    function configure() {
        $j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, _: new Date().getTime() }, function(results) {
            if (results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/user/saml_user/list");
            }
        });
    }

    return { configure: configure };

})(jQuery);
