var module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist(){
		$.ajax({
			'url': '/cli-direct-action?table_gid='+g_cmdb_table_id,
			'dataType': 'json',
			'success': function(response)
		{
			if(response.status == 1)
		{
			source = response.datas;
			gen_qlist();
		}
			else if(response.status == 0)
			error_handler(response.msg_id, "/user/tacacs_plus_user/list");
		},
			'cache': false
		});
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function auth_type_format_fn($td, col, row_data)
	{
		var html = '';
		var type = row_data['auth-type_val'];

		if(type == 0)
			html = 'Auto';
		else if(type == 1)
			html = 'MSCHAP';
		else if(type == 2)
			html = 'CHAP';
		else if(type == 3)
			html = 'PAP';
		else if(type == 4)
			html = 'ASCII';

		return html;
	}

	function gen_qlist(){
		var qlist_settings = {
			'prefix': 'tacacs',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'server', 'lang_key': $j.getInfo("server",flt_lang)},
				{'selector': 'auth-type', 'lang_key': $j.getInfo('auth_type', flt_lang)}
			],
			'default_columns':['id', 'name', 'server', 'auth-type'],
			'column_filters': {
				'enabled': false,
			},
			'format_fn': {
				'auth-type' : auth_type_format_fn,
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
