var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
        	qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    	}

	function filter_type_format_fn($td, col, row_data)
	{
		var val = row_data['filter-type_val'];
		var type = '';
		if(val == 0)
			type = "black";
		else
			type = "white";

		return $j.getInfo(type, flt_lang);
	}
	function gen_qlist(datas){
		
		var settings = {
			'prefix': 'wad_filter',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
                	{name: 'mkey', selector: 'name'},
                	{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'filter-type', 'lang_key': $j.getInfo('filter_type',flt_lang)},
				{'selector': 'sz_members', 'lang_key': $j.getInfo('count',flt_lang)}

			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
            		'callbacks': {
                		'load': content_loaded
            		},
			'default_columns':['id', 'name', 'filter-type', 'sz_members'],
			'format_fn': {
				'filter-type': filter_type_format_fn
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/wad/filter/list');
			}
		});
	}

	return {configure: configure};

})(jQuery);
