var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function wad_handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_mixed_checked_rows();
		if(!is_rw_admin)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			return;
		}

		if(aElems.length == 1)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			qmenu_enable_button($("#mi_edit_" + q.prefix), true, q);
			qmenu_enable_button($("#mi_revert_" + q.prefix), true, q);
		}
		else
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), false, q);
			qmenu_enable_button($("#mi_edit_" + q.prefix), false, q);
			qmenu_enable_button($("#mi_revert_" + q.prefix), false, q);

		}
		if (aElems.length == 0)
		{
			qmenu_enable_button($("#mi_del_" + q.prefix), false, q);
		}else{
			qmenu_enable_button($("#mi_del_" + q.prefix), true, q);
		}

		qmenu_enable_button($("#mi_retrieve_" + q.prefix), true, q);
	}
	function wad_website_delete_elems(q,aElems){
		var url = "/delete?id=" + g_cmdb_table_id + "&type=" + ctype+"&session_id="+session_id;
		var len = aElems.length;
		for(var i=0;i<len;i++){
		var mkey = aElems[i].getAttribute("mkey");
		url += "&mkey=" + mkey;
		}
		$j.submitPOST(url);
	}		
	function wad_website_edit_elems(q){
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;
		var mkey = aElems[0].getAttribute("mkey");
		window.location.href='/wad/website/dlg?id=' + mkey;
	}

	function wad_website_view_elems(q){
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;
		var mkey = aElems[0].getAttribute("mkey");
		window.location.href='/wad/website/view?id=' + mkey;
	}

	function wad_website_onclick_reset(q){
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;
		var mkey = aElems[0].getAttribute("mkey");
		window.location.href='/wad/website/revlist?id=' + mkey;
	}

	function wad_website_onclick_refresh(){
		window.location.href='/wad/website/list'
	}

	function name_format_fn($td, col, row_data)
	{
		var html = '';
		var id = row_data['site_id'];

		html = '<a href="/wad/website/view?id='+ id +'">' + row_data[col.selector] + '</a>';
		return html;
	}

	function monitor_format_fn($td, col, row_data)
	{
		var html = '';
		var sts = row_data[col.selector] ? "enable" : "disable";
		var end = row_data[col.selector]?"ok":"na"

		html = '<img src="/images/st_' + end + '.gif" />' + $j.getInfo(sts, flt_lang);

		return html;
	}

	function connected_format_fn($td, col, row_data)
	{
		var html = '<img src=\"/images/connect_' + row_data[col.selector] + '.gif\" />';
		return html;
	}

	function total_bak_format_fn($td, col, row_data)
	{
		var html = '';
		if(row_data[col.selector] > 0)
		{
			html = '<a href="/wad/file_explorer/frameset?id=' + row_data['site_id'] + '&name=' + row_data['name'] + '">' + row_data[col.selector] + '</a>';
		}
		else 
		{
			html = row_data[col.selector];
		}
		return html;
	}

	function total_change_format_fn($td, col, row_data)
	{
		var html = '';
		if(row_data[col.selector] > 0)
		{
			html = '<a href="/wad/website/changed?id=' + row_data['site_id'] + '">' + row_data[col.selector] + '</a>';
		}
		else
		{
			html = row_data[col.selector];
		}
		return html;
	}

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		source = datas;

		var menu_items = [];
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': wad_website_edit_elems
				},
				'delete': {
					'handler': wad_website_delete_elems
				},
				'mi_view': {
					'id': 'mi_view',
					'class': 'tool_sprite tool_view',
					'handler': wad_website_view_elems,
					'label': qed_strtbl.view
				},
				'mi_revert': {
					'id': 'mi_revert',
					'class': 'tool_sprite tool_revert',
					'handler': wad_website_onclick_reset,
					'label': wad_website_strtbl.reset
				},
				'mi_retrieve': {
					'id': 'mi_retrieve',
					'class': 'tool_sprite tool_retrieve',
					'handler': wad_website_onclick_refresh,
					'label': wad_website_strtbl.refresh
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': wad_website_edit_elems
				},
				'mi_retrieve': {
					'id': 'mi_retrieve',
					'class': 'tool_sprite tool_retrieve',
					'handler': wad_website_onclick_refresh,
					'label': wad_website_strtbl.refresh
				}
			};
		}

		var qlist_settings = {
			'prefix': 'wad_list',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'site_id'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'seq', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'hostname_ip', 'lang_key': $j.getInfo("hostname_ip", flt_lang)},
			{'selector': 'monitor_status', 'lang_key': $j.getInfo("monitor", flt_lang)},
			{'selector': 'connected', 'lang_key': $j.getInfo("connected", flt_lang)},
			{'selector': 'total_file', 'lang_key': $j.getInfo("total_file", flt_lang)},
			{'selector': 'total_bak', 'lang_key': $j.getInfo("total_bak", flt_lang)},
			{'selector': 'total_change', 'lang_key': $j.getInfo("total_change", flt_lang)}
			],
			'default_columns': ['seq', 'name', 'hostname_ip', 'monitor_status', 'connected', 'total_file', 'total_bak', 'total_change'],
			'column_filters': {
				'enabled': false
			},
			'menu_items': menu_items,
			'options': {
				'ref_column': false,
				'sorting': true,
				'sort_columns': {'total_file': true, 'total_bak':true, 'total_change': true}
			},
			'format_fn': {
				'name': name_format_fn,
				'monitor_status': monitor_format_fn,
				'connected': connected_format_fn,
				'total_bak': total_bak_format_fn,
				'total_change': total_change_format_fn

			},
			'handle_selection_change': wad_handle_selection_change,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure() 
	{
		$j.getJSON('/wad/website/list/json', {table_gid: g_cmdb_table_id, vdom: vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/wad/website/list");
			}
		});
	}

	return {configure: configure};
})(jQuery);
