var module_list = (function($) {
	'use strict';

	var ALL_POLICIES = 0;
	var PAGE_LINES = 100;

	var policy=ALL_POLICIES;
	var server_policies = [];

	function fill_options(select, list) {
		var $select = $(select);
		var len = list.length;
		var i = 0;
		for (; i < len; i++) {
			$select.append([
				'<option value="', list[i].ngid, '">', list[i].name, '</option>'
			].join(''));
		}
	}
	
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == 'undefined' ? -1 : g_cmdb_table_id;

		if ($('#view_by_container').length) return;

		var menubar_id = qlist.prefix + '_qlist_yui_menubar';
		var css_selector = '#' + menubar_id + ' > div:first-of-type';
		var $wrapper = $(css_selector);
		$wrapper.prepend([
			'<span id="server_policy_container">',
				$.getInfo('policy'),
				'<select id="server_policy_select">',
					'<option value="', ALL_POLICIES, '">', $.getInfo('all_policies'), '</option>',
				'<select>',
			'</span>'
		].join(''));

		fill_options('#server_policy_select', server_policies);

		$('#server_policy_select').val(policy)
		.on('change', function(eventObject){
			onclick_refresh_handler();
		});
		
	}
	
	function onclick_refresh_handler() {
		policy = $('#server_policy_select').val();
		get_data();
	}

	function operation_format_fn(td, col, row_data) {
		var html = "<a href='#' onclick='module_list.releaseClick(\""+row_data["policy"]+"\", \""+row_data["profile"]+"\",\""+row_data["rule"]+"\",\""+row_data["username"]+"\")'><f-icon class='fa-sign-out' title='"+$.getInfo('operation_tip')+"'></f-icon></a>";
		return html;
	}
	
	function gen_qlist(data) {
		var get_columns = function(){
			var columns = [
				{'selector': 'seq', 'lang_key': '#'},
				{'selector': 'username', 'lang_key': $.getInfo('user')},
				{'selector': 'rule_name', 'lang_key': $.getInfo('site_publish_rule')},
				{'selector': 'operation', 'lang_key': $.getInfo('operation')}
			];
			if(policy == ALL_POLICIES){
				columns = [
					{'selector': 'seq', 'lang_key': '#'},
					{'selector': 'username', 'lang_key': $.getInfo('user')},
					{'selector': 'policy_name', 'lang_key': $.getInfo('policy_name')},
					{'selector': 'rule_name', 'lang_key': $.getInfo('site_publish_rule')},
					{'selector': 'operation', 'lang_key': $.getInfo('operation')}
				];
			}

			return columns;
		};
		var qlist_settings = {
			'prefix': 'active_users',
			'source': data,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': get_columns(),
			'default_columns': ['seq', 'username', 'policy_name', 'rule_name', 'operation'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'hide_default_buttons': true,
			},
			'menu_items': {
				'mi_refresh': {
					'ctxt': false,
					'class': 'tool_retrieve',
					'label': $.getInfo('refresh'),
					'handler': onclick_refresh_handler
				}
			},
			'paging': {
				enabled: true, 
				page_lines: PAGE_LINES
			},
			'format_fn': {
				'operation': operation_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $('#content');
		$container.qlist(qlist_settings);
	}
	
	function get_data() {
		$.getJSON('/waf/active_users/json', {
			policy: policy,
			_: new Date().getTime()
		}, function(result) {
			if (result.status == 1) {
				server_policies = result.server_policies || [];
				gen_qlist(result.active_users || []);
			} else {
				error_handler(result.msg_id, '/waf/active_users/list');
			}
		});
	}
	
	function releaseClick(policy, profile, rule, username)
	{
		$.post("/waf/active_users/release", {
			policy: policy,
			profile: profile,
			rule: rule,
			username: username
		}, function(data, status){
			if(status == "success")
			{
				if(data.status == 1)
				{
					policy = $('#server_policy_select').val();
					get_data();	
				}
				else
				{
					alert("Release process failed.");
				}
				
			}
		});
	}
	function configure () {
		get_data();
	}

	return {
		configure: configure,
		releaseClick: releaseClick
	};

})(jQuery);
