var module_list = (function($) {
    'use strict';

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }

    function gen_qlist(datas) {
        var settings = {
            'prefix': 'waf_apiuser_group',
            'source': datas,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'columns': [
                {'selector': 'id', 'lang_key': '#'},
                {'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
                {'selector': 'sz_user-list', 'lang_key': $.getInfo('count',flt_lang)}
            ],
            'column_filters': {
                'enabled': false
            },
            'options': {
                'ref_column': false,
                'sorting': false
            },
            'default_columns':['id', 'name','sz_user-list'],
            'row_attr': [
                { name: 'mkey', selector: 'name' },
                { name: 'q_ref', selector: 'q_ref' },
            ],
            'callbacks': {
                'load': content_loaded
            }
        };

        var $container = $("#content");
        $container.qlist(settings);
    }

    function configure() {
        $j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, vdom:vdom, _: new Date().getTime() }, function(results) {
            if (results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/waf/api_user_group/list");
            }
        });
    }

    return { configure: configure };

})(jQuery);
