var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function view_click(q)
	{
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;

		var mkey = aElems[0].getAttribute("mkey");
		window.location.href = "/waf/autolearning_profile/dlg?mkey=" + mkey; 
	}

	function clone_click(q)
	{
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;

		var mkey = aElems[0].getAttribute("mkey");
		window.location.href = "/waf/autolearning_profile/dlgcopy?mkey=" + mkey;	
	}
	
	function waf_auto_profile_handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_mixed_checked_rows();
		if(!is_rw_admin)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			return;
		}

		if(aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
			qmenu_enable_button($("#mi_clone_" + q.prefix), true, q);
		else
			qmenu_enable_button($("#mi_clone_" + q.prefix), false, q);

		if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_v")) == 1)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			qmenu_enable_button($("#mi_edit_" + q.prefix), false, q);
		}else{
			qmenu_enable_button($("#mi_view_" + q.prefix), false, q);
		}
	}

	function attack_percent_format_fn($td, col, row_data)
	{
		var percent_val = row_data[col.selector];
		return percent_val ? (percent_val + '%') : '';
	}

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		source = datas;

		var menu_items = [];
		if(is_rw_admin)
		{
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'class': 'tool_sprite tool_view',
					'handler': view_click,
					'label': qed_strtbl.view
				},
				'mi_clone': {
					'id': 'mi_clone',
					'class': 'tool_sprite tool_clone',
					'handler': clone_click,
					'label': qed_strtbl.clone
				}
			};
		}

		var qlist_settings = {
			'prefix': 'auto_learning_profile',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'can_clone', selector: 'can_clone'},
			{name: 'can_v', selector: 'can_view'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'data-type-group', 'lang_key': $j.getInfo("data_type", flt_lang)},
			{'selector': 'suspicious-url-rule', 'lang_key': $j.getInfo("url_rule", flt_lang)},
			{'selector': 'attack-count-threshold', 'lang_key': $j.getInfo("att_count", flt_lang)},
			{'selector': 'attack-percent-range', 'lang_key': $j.getInfo("att_percent", flt_lang)},
			{'selector': 'application-policy', 'lang_key': $j.getInfo("app_policy", flt_lang)},
			],
			'default_columns': ['id', 'name', 'data-type-group', 'suspicious-url-rule', 'attack-count-threshold', 'attack-percent-range', 'application-policy'],
			'column_filters': {
				'enabled': false
			},
			'menu_items': menu_items,
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'format_fn': {
				'attack-percent-range': attack_percent_format_fn
			},
			'handle_selection_change': waf_auto_profile_handle_selection_change,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure() 
	{
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/waf/autolearning_profile/list");
			}
		});
	}

	return {configure: configure};
})(jQuery);
