var module_list = (function($) {
	'use strict';

	var BLOCKED_BY_USER_TRACKING = 1,
		BLOCKED_BY_SITE_PUBLISH = 2;
	var ALL_POLICIES = 0;
	var PAGE_LINES = 100;

	var type = BLOCKED_BY_USER_TRACKING,
		policy = ALL_POLICIES;

	var server_policies = [];

	function username_format_fn(td, col, row_data) {
		var username = row_data[col.selector];
		if (policy != ALL_POLICIES) return username;

		var policy_ngid = row_data['policy'];
		var len = server_policies.length;
		var i = 0;
		var policy_obj, policy_name;
		for (; i < len; i++) {
			policy_obj = server_policies[i];
			if (policy_obj.ngid == policy_ngid) {
				policy_name = policy_obj.name;
				break;
			}
		}

		return username+' ('+policy_name+')';
	}

	function release_format_fn(td, col, row_data) {
		return [
			'<a href="#" class="release_trigger" data-policy="', row_data['policy'],
			'" data-user="', row_data['username'], '" data-sid="', row_data['sid'], '">',
				'<span class="tool_sprite tool_delete"></span>',
			'</a>'
		].join('');
	}

	function onclick_release_handler(trigger) {
		var $trigger = $(trigger);
		$.getJSON('/waf/blocked_users/del', {
			type: type,
			policy: $trigger.data('policy'),
			user: encodeURIComponent($trigger.data('user')),
			sid: $trigger.data('sid')
		}, function(result) {
			if (result.status == 1) {
				get_data();
			} else {
				error_handler(result.msg_id, '/waf/blocked_users/list');
			}
		});
	}

	function onclick_refresh_handler() {
		type = $('#view_by_select').val();
		policy = $('#server_policy_select').val();
		get_data();
	}

	function fill_options(select, list) {
		var $select = $(select);
		var len = list.length;
		var i = 0;
		for (; i < len; i++) {
			$select.append([
				'<option value="', list[i].ngid, '">', list[i].name, '</option>'
			].join(''));
		}
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == 'undefined' ? -1 : g_cmdb_table_id;

		if ($('#view_by_container').length) return;

		var menubar_id = qlist.prefix + '_qlist_yui_menubar';
		var css_selector = '#' + menubar_id + ' > div:first-of-type';
		var $wrapper = $(css_selector);
		$wrapper.prepend([
			'<span id="view_by_container">',
				$.getInfo('view_by'),
				'<select id="view_by_select">',
					'<option value="', BLOCKED_BY_USER_TRACKING, '">', $.getInfo('user_tracking'), '</option>',
					'<option value="', BLOCKED_BY_SITE_PUBLISH, '">', $.getInfo('site_publish'), '</option>',
				'<select>',
			'</span>',
			'<span id="server_policy_container">',
				$.getInfo('policy'),
				'<select id="server_policy_select">',
					'<option value="', ALL_POLICIES, '">', $.getInfo('all_policies'), '</option>',
				'<select>',
			'</span>'
		].join(''));

		fill_options('#server_policy_select', server_policies);

		$('#view_by_select').val(type)
		.on('change', function(eventObject){
			onclick_refresh_handler();
		});

		$('#server_policy_select').val(policy)
		.on('change', function(eventObject){
			onclick_refresh_handler();
		});

		$('a.release_trigger').on('click', function(eventObject){
			eventObject.preventDefault();
			onclick_release_handler(this);
		});

		// Fix width of the 1st and the 3rd column
		// $('#'+qlist.prefix+'-qlist tr.heading > th').eq(0).css('width', '100px');
		// $('#'+qlist.prefix+'-qlist tr.heading > th').eq(2).css('width', '200px');
	}

	function gen_qlist(data) {
		var qlist_settings = {
			'prefix': 'blocked_users',
			'source': data,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'seq', 'lang_key': '#'},
				{'selector': 'username', 'lang_key': $.getInfo('user')},
				{'selector': 'release', 'lang_key': $.getInfo('release')}
			],
			'default_columns': ['seq', 'username', 'release'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'hide_default_buttons': true,
			},
			'menu_items': {
				'mi_refresh': {
					'ctxt': false,
					'class': 'tool_retrieve',
					'label': $.getInfo('refresh'),
					'handler': onclick_refresh_handler
				}
			},
			'paging': {
				enabled: true, 
				page_lines: PAGE_LINES
			},
			'format_fn': {
				'username': username_format_fn,
				'release': release_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $('#content');
		$container.qlist(qlist_settings);
	}

	function get_data() {
		$.getJSON('/waf/blocked_users/json', {
			type: type,
			policy: policy
		}, function(result) {
			if (result.status == 1) {
				server_policies = result.server_policies || [];
				gen_qlist(result.blocked_users || []);
			} else {
				error_handler(result.msg_id, '/waf/blocked_users/list');
			}
		});
	}

	function configure () {
		get_data();
	}

	return {configure: configure};

})(jQuery);
