var module_list = (function($) {
	'use strict';
	
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function gen_qlist(datas) {
		var settings = {
			'prefix': 'bot_miti_policy',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang)},
				{'selector': 'bot-deception', 'lang_key': $j.getInfo('bot_deception', flt_lang)},
				{'selector': 'biometrics-based-detection', 'lang_key': $j.getInfo('bot_behaviour', flt_lang)},
				{'selector': 'threshold-based-detection', 'lang_key': $j.getInfo('bot_traffic', flt_lang)},
			],
			'column_filters': {
				'enabled': false,
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
			'callbacks': {
				'load': content_loaded
			},
			'default_columns':['id', 'name', 'bot-deception', 'biometrics-based-detection', 'threshold-based-detection'],
			'search': { 'enabled': false },
			'format_fn': {
			},
		};

		var $container = $("#content");

		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/bot_miti_policy/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
