var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		var th_len = $('table thead tr th').length;
		$('table tbody tr').first().before("<tr id='tr_session_management' style=\"background-color: #FFD710\" valign=\"middle\">"
			+"<td colspan="+th_len+"><img id=\"wij_modal_close_btn_fixed\" "
			+"src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
			+" onclick=\"document.getElementById('tr_session_management').style.display='none';\">"
			+$j.getInfo('need_sys_share_ip')+"</td></tr>");
	}
	
	function lang_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data);
	}
	
	function view_click(q)
	{
		var aElems = q.get_checked_rows();
		if (aElems.length != 1) return;

		var mkey = aElems[0].getAttribute("mkey");
		window.location.href = "/waf/brute_force_login/dlg?mkey=" + mkey + "&vdom=" + vdom; 
	}

	function clone_click(qlist, elems)
	{
		var clone_url = '/waf/brute_force_login/dlgcopy';
		var mkey = qlist_get_row_attr(elems, 'mkey');
		if(mkey){
			clone_url += '?mkey=' + encodeURIComponent(mkey);
			if(vdom) clone_url += '&vdom=' + encodeURIComponent(vdom);
			window.location.href = clone_url;	
		}
	}
	
	function waf_brute_handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_mixed_checked_rows();
		if(!is_rw_admin)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			return;
		}

		if(aElems.length == 1 && parseInt(aElems[0].getAttribute("can_clone")) == 1)
			qmenu_enable_button($("#mi_clone_" + q.prefix), true, q);
		else
			qmenu_enable_button($("#mi_clone_" + q.prefix), false, q);

		if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_v")) == 1)
		{
			qmenu_enable_button($("#mi_view_" + q.prefix), true, q);
			qmenu_enable_button($("#mi_edit_" + q.prefix), false, q);
		}else{
			qmenu_enable_button($("#mi_view_" + q.prefix), false, q);
		}
	}

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		source = datas;

		var menu_items = [];
		if(is_rw_admin)
		{
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'class': 'tool_sprite tool_view',
					'handler': view_click,
					'label': qed_strtbl.view
				},
				'mi_clone': {
					'id': 'mi_clone',
					'class': 'tool_sprite tool_clone',
					'handler': clone_click,
					'label': qed_strtbl.clone
				}
			};
		}

		var qlist_settings = {
			'prefix': 'brute_force_login',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'can_clone', selector: 'can_clone'},
			{name: 'can_v', selector: 'can_view'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'severity', 'lang_key': $j.getInfo("severity", flt_lang)},
			{'selector': 'trigger', 'lang_key': $j.getInfo("trigger", flt_lang)},
			{'selector': 'sz_login-page-list', 'lang_key': $j.getInfo("count")},
			],
			'default_columns': ['id', 'name', 'severity', 'trigger', 'sz_login-page-list'],
			'column_filters': {
				'enabled': false
			},
			'menu_items': menu_items,
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'format_fn': {
				'severity' : lang_format_fn
			},
			'handle_selection_change': waf_brute_handle_selection_change,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure() 
	{
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/waf/brute_force_login/list");
			}
		});
	}

	return {configure: configure};
})(jQuery);
