var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		var th_len = $('table thead tr th').length;
		$('table tbody tr').first().before(
				"<tr id=\"tr_tip_session_management\" style=\"background-color: #FFD710\" valign=\"middle\"><td colspan=\""+th_len+"\">"
				+"<img id=\"wij_modal_close_btn_fixed\" src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
				+" onclick=\"document.getElementById('tr_tip_session_management').style.display='none';\">"
				+$j.getInfo("tip_session_management", flt_lang)+"</td></tr>");
	}
	
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}
	
	function local_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "no") ? $j.getInfo("none", flt_lang) : $j.getInfo(data, flt_lang);
	}

	function gen_qlist(datas){
		
		var settings = {
			'prefix': 'cookie_security_policy',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
			{'selector': 'security-mode', 'lang_key': $j.getInfo('security_mode', flt_lang)},
			{'selector': 'cookie-replay-protection-type', 'lang_key': $j.getInfo('cookie_replay', flt_lang)},
			{'selector': 'allow-suspicious-cookies', 'lang_key': $j.getInfo('allow_type', flt_lang)},
			{'selector': 'max-age', 'lang_key': $j.getInfo('cookie_max_age', flt_lang)},
			{'selector': 'secure-cookie', 'lang_key': $j.getInfo('secure_cookie', flt_lang)},
			{'selector': 'http-only', 'lang_key': $j.getInfo('http_only', flt_lang)},
			{'selector': 'action', 'lang_key': $j.getInfo('action',flt_lang)},
			{'selector': 'block-period', 'lang_key': $j.getInfo('block_period',flt_lang)},
			{'selector': 'severity', 'lang_key': $j.getInfo('severity',flt_lang)},
			{'selector': 'trigger', 'lang_key': $j.getInfo('trigger_policy',flt_lang)},
			{'selector': 'sz_cookie-security-exception-list', 'lang_key': $j.getInfo('count',flt_lang)},

			],
			'column_filters': {
				'enabled': false
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
			'callbacks': {
				'load': content_loaded
			},
			'default_columns':['id', 'name', 'security-mode', 'cookie-replay-protection-type', 'allow-suspicious-cookies', 'action', 'sz_cookie-security-exception-list'],
			'search': { 'enabled': false },
			'format_fn': {
				'action': lang_format_fn,
				'http-only': lang_format_fn,
				'secure-cookie': lang_format_fn,
				'security-mode': local_format_fn,
				'cookie-replay-protection-type': local_format_fn,
				'allow-suspicious-cookies': lang_format_fn,
				'severity': lang_format_fn
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/cookie_security_policy/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
