var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function sz_allowed_methods_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var enable = row_data['block-cors-traffic'];
		var allowed_methods = row_data['allowed-methods'];
		if(enable == 'disable' && allowed_methods == 'enable')
			return data;
		else
			return 0;
	}
	function sz_allowed_headers_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var enable = row_data['block-cors-traffic'];
		var allowed_headers = row_data['allowed-headers'];
		if(enable == 'disable' && allowed_headers == 'enable')
			return data;
		else
			return 0;
	}
	function sz_exposed_headers_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var enable = row_data['block-cors-traffic'];
		var exposed_headers = row_data['exposed-headers'];
		if(enable == 'disable' && exposed_headers == 'enable')
			return data;
		else
			return 0;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'cors_rule',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'sz_allowed-methods-list', 'lang_key': $j.getInfo("allowed_methods_count",flt_lang)},
				{'selector': 'sz_allowed-headers-list', 'lang_key': $j.getInfo("allowed_headers_count",flt_lang)},
				{'selector': 'sz_exposed-headers-list', 'lang_key': $j.getInfo("exposed_headers_count",flt_lang)}
			],
			'default_columns':['id', 'name', 'sz_allowed-methods-list', 'sz_allowed-headers-list', 'sz_exposed-headers-list'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'format_fn': {
				'sz_allowed-methods-list': sz_allowed_methods_format_fn,
				'sz_allowed-headers-list': sz_allowed_headers_format_fn,
				'sz_exposed-headers-list': sz_exposed_headers_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/cors_rule/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
