var module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist()
	{
		$.ajax({
			'url': '/waf/csrf/list/json?vdom='+vdom,
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.results;
					gen_qlist();
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/waf/csrf/list?vdom="+vdom);
			},
			'cache': false
		});
	}

	function lang_format_fn($td, col, row_data)
	{
		//var data = row_data[col.selector].toLowerCase();
		var data = row_data[col.selector];
        return (data === "") ? data : $j.getInfo(data, flt_lang);
    }

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		var th_len = $('table thead tr th').length;

		$('table tbody tr').first().before(
				"<tr id=\"tr_session_management\" style=\"background-color: #FFD710\" valign=\"middle\"><td colspan=\""+th_len+"\">"
				+"<img id=\"wij_modal_close_btn_fixed\" src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
				+" onclick=\"document.getElementById('tr_session_management').style.display='none';\">"
				+$j.getInfo("need_session_management", fgt_lang)+"</td></tr>");
	}

	function gen_qlist(){
		var qlist_settings = {
			'prefix': 'csrf',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'seq', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)},
				{'selector': 'block-period', 'lang_key': $j.getInfo("block_period",flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity', flt_lang)},
				{'selector': 'trigger', 'lang_key': $j.getInfo("trigger",flt_lang)},
			],
			'default_columns':['seq','name', 'action', 'block-period', 'severity', 'trigger'],
			'column_filters': {
				'enabled': false,
			},
			'format_fn': {
				'action': lang_format_fn,
				'severity': lang_format_fn
			},
//			'handle_selection_change': selection_changed,
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
