var module_list = (function($) {
	'use strict';

	var source;
	var action_lang = {
		'alert': "alert",
		'alert_deny': "alert_deny",
		'deny_no_log': "deny_no_log",
		'redirect': "redirect",
		'alert_erase': "alert_erase",
		'only_erase': "only_erase",
		'block-period': "period_block",
		'send_http_response': "send_http_response",
	};
	var severity_lang = {
		'High': 'High',
		'Medium': 'Medium',
		'Low': 'Low',
		'Info': 'Info'
	};

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function option_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var options_lang = null;
		if(col.selector == 'action')
			options_lang = action_lang;
		else if(col.selector == 'severity')
			options_lang = severity_lang;
		else
			return '';

		var lang = options_lang[data] ? options_lang[data] : '';
		return (lang === '') ? lang : $j.getInfo(lang,flt_lang);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'waf_cus_sig',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'type', 'lang_key': $j.getInfo("type",flt_lang)},
			{'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)},
			{'selector': 'block-period', 'lang_key': $j.getInfo("block_period",flt_lang)},
			{'selector': 'severity', 'lang_key': $j.getInfo("severity",flt_lang)},
			{'selector': 'trigger', 'lang_key': $j.getInfo("trigger",flt_lang)},
			],
			'default_columns':['id', 'name', 'type', 'action', 'block-period', 'severity', 'trigger'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'type': lang_format_fn,
				'action': option_format_fn,
				'severity': option_format_fn,
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/custom_signature/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
