var module_list = (function($) {
	'use strict';

	var source;

	function g_lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}

	function handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view',fgt_lang),
					'class': 'tool_view',
					'handler': edit_click,
				}
			};
		}

		var qlist_settings = {
			'prefix': 'waf_dos_pro_pol',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'handle_selection_change': handle_selection_change,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			{name: 'default_flag', selector: 'can_view'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'enable-http-session-based-prevention', 'lang_key': $j.getInfo("enable_http_session_based_pre",flt_lang)},
			{'selector': 'enable-layer4-dos-prevention', 'lang_key': $j.getInfo("enable_layer4_dos_pre",flt_lang)},
			],
			'default_columns':['id', 'name', 'enable-http-session-based-prevention', 'enable-layer4-dos-prevention'],
			'column_filters': {
				'enabled': false,
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'enable-http-session-based-prevention': g_lang_format_fn,
				'enable-layer4-dos-prevention': g_lang_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/dos_pro_pol/list?vdom="+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
