var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		
		var settings = {
			'prefix': 'url_access_rule',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'sz_exempted-url-list', 'lang_key': $j.getInfo('count',flt_lang)},
			],
			'column_filters': {
				'enabled': false,
				'exempts': ['id', 'name', 'sz_exempted-url-list']
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
			'callbacks': {
				'load': content_loaded
			},
			'default_columns':['id', 'name', 'sz_exempted-url-list']
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/exempted_url/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
