var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var c = data[0].toUpperCase();
		return c + data.substr(1);
	}

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		
		source = datas;

		var qlist_settings = {
			'prefix': 'file_compress',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'compression-type', 'lang_key': $j.getInfo("type", flt_lang)},
			{'selector': 'exclude-url', 'lang_key': $j.getInfo("exclude_url", flt_lang)},
			{'selector': 'sz_content-types', 'lang_key': $j.getInfo("list", flt_lang)}
			],
			'default_columns': ['id', 'name', 'compression-type', 'exclude-url', 'sz_content-types'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'name', 'compression-type', 'sz_content-types']
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'compression-type': type_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure() 
	{
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/waf/file_compress_rule/list");
			}
		});
	}

	return {configure: configure};
})(jQuery);
