var module_list = (function($) {
    'use strict';

    var action_lang = {
        'alert' : 'alert',
        'alert_deny' : 'alert_deny',
        'deny_no_log': 'deny_no_log',
        'block-period' : 'period_block'
    };
    var severity_lang = {
        'High' : 'High',
        'Medium' : 'Medium',
        'Low' : 'Low',
        'Info' : 'Info'
    };

    function option_format_fn(td, col, row_data){
        var data = row_data[col.selector];
        var options_lang = null;
        if(col.selector == 'action')
            options_lang = action_lang;
        else if(col.selector == 'severity')
            options_lang = severity_lang;
        else
            return '';

        var lang = options_lang[data] ? options_lang[data] : '';
        return (lang === '') ? lang : $.getInfo(lang,flt_lang);
    }

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }

    function gen_qlist(datas) {
        var settings = {
            'prefix': 'waf_ftp_command_rule',
            'source': datas,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'columns': [
                {'selector': 'id', 'lang_key': '#'},
                {'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
                {'selector': 'action', 'lang_key': $.getInfo('action',fgt_lang)},
                {'selector': 'severity', 'lang_key': $.getInfo('severity',fgt_lang)},
                {'selector': 'trigger', 'lang_key': $.getInfo('trigger',flt_lang)}
            ],
            'column_filters': {
                'enabled': false
            },
            'options': {
                'ref_column': false,
                'sorting': false
            },
            'default_columns':['id', 'name', 'action', 'severity', 'trigger'],
            'row_attr': [
                { name: 'mkey', selector: 'name' },
                { name: 'q_ref', selector: 'q_ref' },
            ],
            'format_fn': {
                'action': option_format_fn,
                'severity': option_format_fn
            },
            'callbacks': {
                'load': content_loaded
            }
        };

        var $container = $("#content");
        $container.qlist(settings);
    }

    function configure() {
        $j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, vdom:vdom, _: new Date().getTime() }, function(results) {
            if (results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/waf/ftp_command_rule/list");
            }
        });
    }

    return { configure: configure };

})(jQuery);
