var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	
	function lang_format_fn($td, col, row_data)
	{
		var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data, flt_lang);
	}
	function action_format_fn($td, col, row_data)
	{
		var action_val = row_data.action_val;
		var action_str = "";
		if(action_val == "2"){
			action_str = $j.getInfo("alert", flt_lang);
		}
		else if(action_val == "6"){
			action_str = $j.getInfo("alert_deny", flt_lang);
		}
		else if(action_val == "11"){
			action_str = $j.getInfo("period_block", flt_lang);
		}
		else if(action_val == "4"){
			action_str = $j.getInfo("deny_no_log", flt_lang);
		}
		else{}

		return action_str;
	}

	function severity_format_fn($td, col, row_data)
	{
		var sev_val = row_data.severity_val;
		var severity = "";

		if(sev_val == "1")
		{
			severity = $j.getInfo("High", flt_lang);
		}
		else if(sev_val == "2")
		{
			severity = $j.getInfo("Medium", flt_lang);
		}
		else if(sev_val == "3")
		{
			severity = $j.getInfo("Low", flt_lang);
		}
		else if(sev_val == "4")
		{
			severity = $j.getInfo("Info", flt_lang);
		}
		else{}

		return severity;
	}

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		
		source = datas;

		var qlist_settings = {
			'prefix': 'ftp_file_check',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'action', 'lang_key': $j.getInfo("action", flt_lang)},
			{'selector': 'block-period', 'lang_key': $j.getInfo("block_period", flt_lang)},
			{'selector': 'severity', 'lang_key': $j.getInfo("severity", flt_lang)},
			{'selector': 'trigger', 'lang_key': $j.getInfo("trigger", flt_lang)},
			{'selector': 'av-scan', 'lang_key': $j.getInfo("anti_scan", flt_lang)},
			{'selector': 'send-files-to-fortisandbox', 'lang_key': $j.getInfo("threat_scan", flt_lang)},
			{'selector': 'icap-server-check', 'lang_key': $j.getInfo("icap_check", flt_lang)}
			],
			'default_columns': ['id', 'name', 'action', 'block-period', 'severity', 'trigger', 'av-scan', 'send-files-to-fortisandbox', 'icap-server-check'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'format_fn': {
				'action' : action_format_fn,
				'severity' : severity_format_fn,
				'av-scan': lang_format_fn,
				'send-files-to-fortisandbox': lang_format_fn,
				'icap-server-check': lang_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}

	function configure() 
	{
		$j.getJSON('/cli-direct-action', {table_gid: g_cmdb_table_id, vdom: vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			}
			else
			{
				error_handler(results.msg_id, "/waf/ftp_file_check/list");
			}
		});
	}

	return {configure: configure};
})(jQuery);
