var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, fgt_lang);
	}
	function gen_qlist(datas){
		
		var settings = {
			'prefix': 'geo_ip',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
                {name: 'mkey', selector: 'name'},
                {name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity',flt_lang)},
				{'selector': 'trigger', 'lang_key': $j.getInfo('triggerAction',flt_lang)},
				{'selector': 'exception-rule', 'lang_key': $j.getInfo('exception',flt_lang)},
				{'selector': 'sz_country-list', 'lang_key': $j.getInfo('count',flt_lang)},

			],
			'column_filters': {
				'enabled': true,
                'exempts': ['id', 'name', 'severity', 'trigger', 'exception-rule', 'sz_country-list']
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
            'callbacks': {
                'load': content_loaded
            },
			'default_columns':['id', 'name', 'severity', 'trigger', 'exception-rule', 'sz_country-list'],
			'search': { 'enabled': false },
			'format_fn': {
				'severity': lang_format_fn,
			},
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/geo_block_list/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
