top.cur_hf_protection = "";
top.cur_hf_rule = "";

var module_list = (function($) {
    'use strict';

    var source;

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }
    function lang_format_fn(td, col, row_data){
        var data = row_data[col.selector];
        return (data === "") ? data : $j.getInfo(data,fgt_lang);
    }
    function escapeHTML_format_fn(td, col, row_data){
        var data = row_data[col.selector];
        return (data !== "") ? escapeHTML(data) : '';
    }

    function gen_qlist(datas){
        if (!window.fgt_lang || !fgt_lang["global"])
            $j.addLang();
        source = datas;

        var qlist_settings = {
            'prefix': 'waf_hidf_rule',
            'source': source,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'row_attr': [
                {name: 'mkey', selector: 'name'},
                {name: 'q_ref', selector: 'q_ref'},
            ],
            'columns': [
                {'selector': 'id', 'lang_key': '#'},
                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
                {'selector': 'host-status', 'lang_key': $j.getInfo("host_status",flt_lang)},
                {'selector': 'host', 'lang_key': $j.getInfo("host",flt_lang)},
                {'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)},
                {'selector': 'request-file', 'lang_key': $j.getInfo("req_url",flt_lang)},
                {'selector': 'severity', 'lang_key': $j.getInfo("severity",flt_lang)},
                {'selector': 'trigger', 'lang_key': $j.getInfo("triggerAction",flt_lang)}
            ],
            'default_columns':['id', 'name', 'host-status', 'host'],
            'column_filters': {
                'enabled': true,
                'exempts': ['id', 'name', 'host-status', 'action', 'severity', 'trigger']
            },
            'options':{
                'ref_column': false,
                'sorting': false,
            },
            'callbacks': {
                'load': content_loaded
            },
            'format_fn': {
                'host-status': lang_format_fn,
                'action': lang_format_fn,
                'severity': lang_format_fn,
                'request-file':escapeHTML_format_fn
            }
        };

        var $container = $("#content");
        $container.qlist(qlist_settings);

    }

    function configure () {
        $j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()}, function(results) {
            if(results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/waf/hidden_rule/list");
            }
        });
    }

    return {configure: configure};

})(jQuery);
