var module_list = (function($) {
	'use strict';

	var source;

	function g_lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, flt_lang);
	}

	function handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		var th_len = $('table thead tr th').length;

		$('table tbody tr').first().before(
			"<tr id=\"tr_sys_share_ip\" style=\"background-color: #FFD710\" valign=\"middle\"><td colspan=\""+th_len+"\">"
			+"<img id=\"wij_modal_close_btn_fixed\" src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
			+" onclick=\"document.getElementById('tr_sys_share_ip').style.display='none';\">"
			+$j.getInfo("need_sys_share_ip", fgt_lang)+"</td></tr>");
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view',fgt_lang),
					'class': 'tool_view',
					'handler': edit_click,
				}
			};
		}

		var qlist_settings = {
			'prefix': 'waf_http_access',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'handle_selection_change': handle_selection_change,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			{name: 'default_flag', selector: 'can_view'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'access-limit-standalone-ip', 'lang_key': $j.getInfo("access_limit_standalone_ip",flt_lang)},
			{'selector': 'access-limit-share-ip', 'lang_key': $j.getInfo("access_limit_share_ip",flt_lang)},
			{'selector': 'bot-recognition', 'lang_key': $.getInfo('for_browser', flt_lang)},
			{'selector': 'validation-timeout', 'lang_key': $.getInfo('validation_timeout', flt_lang)},
			{'selector': 'max-attempt-times', 'lang_key': $.getInfo('max_attempt_times', flt_lang)},
			{'selector': 'mobile-app-identification', 'lang_key': $.getInfo('for_mobile_app', flt_lang)},
			{'selector': 'bot-confirmation', 'lang_key': $.getInfo('bot_confirmation', flt_lang)},
			],
			'default_columns':['id', 'name', 'access-limit-standalone-ip', 'access-limit-share-ip', 'bot-confirmation'],
			'column_filters': {
				'enabled': false,
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'bot-recognition': g_lang_format_fn,
				'mobile-app-identification': g_lang_format_fn,
				'bot-confirmation': g_lang_format_fn,
				'validation-timeout': function(td, col, row_data) {
					var data = row_data[col.selector];
					var bot_recognition = row_data['bot-recognition'];
					if (bot_recognition != 'disabled') { // bot recognition is not disabled
						return data;
					} else {
						return '-';
					}
				},
				'max-attempt-times': function(td, col, row_data) {
					var data = row_data[col.selector];
					var bot_recognition = row_data['bot-recognition'];
					if (bot_recognition == 'captcha-enforcement') { // bot recoginitin is captcha-enforcement
						return data;
					} else {
						return '-';
					}
				}
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,_:new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/http_access_limit_rule/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
