var module_list = (function($) {
	'use strict';

	var source;

	function status_format_fn(td, col, row_data){

		var enable = parseInt(row_data[col.selector]);
		var html = '<input type="checkbox" class="toggle-switch" name="ip_repu_enable' + row_data['id'] + '" id="ip_repu_enable' + row_data['id'] +  '" '+ (enable? 'checked ' : '');
		if(is_rw_admin)
			html += 'onclick="window.location=\'/waf/whitelist/list?mkey='+ encodeURIComponent(row_data.id) +'&session_id='+ encodeURIComponent(session_id) +'\'"';
		else
			html += 'disabled';
		html += '/><label for="ip_repu_enable' + row_data['id'] + '"></label>';

		return html;
	}

	function whitelist_delete_elems(q, aElems)
	{
		var url = "/delete?&session_id="+session_id;

		var len = aElems.length;
		for (var i=0; i<len; i++)
		{
			var mkey = aElems[i].getAttribute("mkey");
			url += "&id=" +g_cmdb_table_id + "&mkey=" + mkey + "&type=0";	
		}

		$.submitPOST(url);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'menu_items': {
				'delete': {
					'handler': whitelist_delete_elems,
				}
			},
			'prefix': 'waf_ip_int_excp',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'id'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'ip', 'lang_key': $j.getInfo("ip",flt_lang)},
			{'selector': 'status_val', 'lang_key': $j.getInfo("enable",flt_lang)}
			],
			'default_columns':['id', 'ip', 'status_val'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'status_val']
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'status_val': status_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/whitelist/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
