var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function json_file_handle_selection_change(q)
    {
            qlist_handle_selection_change(q);

            var aElems = q.get_checked_rows();
            var mi_view = $("#mi_view_" + q.prefix);
            if(!is_rw_admin)
            {
                    qmenu_enable_button(mi_view, true, q);
                    return;
            }
            if (aElems.length == 1)
            {
                    qmenu_enable_button(mi_view, true, q);
            }else{
                    qmenu_enable_button(mi_view, false, q);
            }            
    }

	function gen_qlist(datas) {
		var menu_items = {};
        if(is_rw_admin){
                menu_items = {
                        'mi_view': {
                                'id': 'mi_view',
                                'label': $.getInfo('view_details',flt_lang),
                                'class': 'tool_view',
                                'handler': edit_click,
                        }
                };
        }
		var settings = {
			'prefix': 'waf_json_schema_file',
			'source': datas,
			'handle_selection_change': json_file_handle_selection_change,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'hide_edit_button': true,
				'ref_column': false,
				'sorting': false
			},
			'default_columns': ['id', 'name'],
			'row_attr': [
				{ name: 'mkey', selector: 'name' },
				{ name: 'q_ref', selector: 'q_ref' },
			],
			'callbacks': {
				'load': content_loaded,
				'dblclick': edit_click
			}
		};

		var $container = $("#content");
		$container.qlist(settings);
	}

	function configure() {
		$j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, _: new Date().getTime() }, function(results) {
			if (results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/json_schema_file/list");
			}
		});
	}

	return { configure: configure };

})(jQuery);
