
var del_type = 0; //for delete type
var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }
	function g_lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, flt_lang);
	}
	function bot_edit_click(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'mkey');
		var policy_id = qlist_get_row_attr(elems, 'policy_id');
		if(mkey){
			mkey = encodeURIComponent(mkey);
			edit_url = qlist_url_append_arg(edit_url, 'mkey', mkey);	
			edit_url = qlist_url_append_arg(edit_url, 'policy_id', policy_id);	
			window.location.href = edit_url;
		}
	}
	function handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);
		
		if (aElems.length == 1)
		{
			if(!is_rw_admin)
			{
				qmenu_enable_button(mi_view, true, q);
				return;
			}else
				qmenu_enable_button(mi_edit, true, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}	
	function gen_qlist(datas){
		var menu_items = {};
		if(is_rw_admin)
		{
			menu_items = {
				'mi_edit': {
					'id': 'mi_edit',
					'ctxt': true,
					'class': 'tool_sprite tool_edit',
					'handler': bot_edit_click,
					'label': $.getInfo('edit', flt_lang)
				},

			};

		}else{
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'ctxt': true,
					'class': 'tool_sprite tool_view',
					'handler': bot_edit_click,
					'label': $.getInfo('view', flt_lang)
				},

			};			
		}
		var settings = {
			'prefix': 'waf_ml_bot_detection_policy',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'handle_selection_change': handle_selection_change,
			'row_attr': [
                {name: 'mkey', selector: 'id'},
                {name: 'policy_id', selector: 'policy_id'},
                {name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'policy', 'lang_key': $j.getInfo('policy',flt_lang)},
				{'selector': 'model_status', 'lang_key': $j.getInfo('model_status',flt_lang)},
				{'selector': 'model_selected', 'lang_key': $j.getInfo('model_policy',flt_lang)},
				{'selector': 'client_identification_method', 'lang_key': $j.getInfo('client_identification_method',flt_lang)},
				{'selector': 'bot_confirmation', 'lang_key': $j.getInfo('bot_confirmation',flt_lang)},		
				{'selector': 'identification_method', 'lang_key': $j.getInfo('identification_method',flt_lang)},						
				{'selector': 'validation-timeout', 'lang_key': $j.getInfo('validation_timeout',flt_lang)},
				{'selector': 'max-attempt-times', 'lang_key': $j.getInfo('max_attempt_times', flt_lang)}
			],
			'column_filters': {
				'enabled': false
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
				'hide_create_button': true,
				'hide_edit_button': true
			},
            'callbacks': {
                'load': content_loaded,
                'dblclick': bot_edit_click
            },
			'default_columns':['id', 'policy', 'model_status', 'model_selected', 'client_identification_method', 'bot_confirmation'],
			'search': { 'enabled': false },
			'format_fn': {
				'identification_method': g_lang_format_fn,
				'validation-timeout': function(td, col, row_data) {
					var data = row_data[col.selector];
					var bot_recognition = row_data['bot_confirmation'];
					var identification_method = row_data['identification_method'];
					if (bot_recognition != 'Disable' && identification_method != '-') { // identification_method is not disabled
						return data;
					} else {
						return '-';
					}
				},
				'max-attempt-times': function(td, col, row_data) {
					var data = row_data[col.selector];
					var bot_recognition = row_data['bot_confirmation'];
					var identification_method = row_data['identification_method'];
					if (bot_recognition != 'Disable' && identification_method == 'captcha') { // identification_method is captcha-enforcement
						return data;
					} else {
						return '-';
					}
				}
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/waf/ml_bot_detection_policy/json', {_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.results);
			} else {
				error_handler(results.msg_id, '/waf/ml_bot_detection_policy/list');
			}
		});
	}

	return {configure: configure};

})(jQuery);
