$j(function(){
	$j('<div id="progress_dialog" style="display:none;"><div id="progressbar"><div class="progress_label">0%</div></div></div>').appendTo($j('body'));
	$j('<div id="import_dialog" style="display:none;"><form enctype="multipart/form-data" id="import_form"><div><div class="label">'+$j.getInfo('import_file')+'</div><div><input type="file" name="import_file"></div></div><input type="hidden" name="type" value="1"><input type="hidden" name="id" id="import_id" value=""></form></div>').appendTo($j('body'));
	$j('<div id="result_dialog" style="display:none;"><div id="result_msg" class="label"></div></div></div>').appendTo($j('body'));

	var progress_dialog = $j('#progress_dialog').dialog({
		modal: true,
		width: 400,
		draggable: false,
		autoOpen: false,
		dialogClass: 'progress_dialog',
		buttons: []
	});

	var progressbar = $j('#progressbar').progressbar({
		value: 0,
		change: function() {
			$j('.progress_label').text( progressbar.progressbar( "value" ) + "%" );
		},
	});

	var import_dialog = $j("#import_dialog").dialog({
		title: $j.getInfo("import_dialog"),
		modal: true,
		width: 600,
		draggable: false,
		autoOpen: false,
		dialogClass: 'import_dialog',
		buttons: [{
			text: $j.getInfo("import"),
			click: clickImport
		},{
			text: $j.getInfo("cancel"),
			click: clickCancel
		}]
	});

	var result_dialog = $j('#result_dialog').dialog({
		modal: true,
		width: 400,
		draggable: false,
		autoOpen: false,
		dialogClass: 'result_dialog',
		buttons: [{
			text: $j.getInfo('ok'),
			click: function() {
				$j('#result_dialog').dialog('close')
			}
		}]
	});

	function clickImport() {
		var options = {
			url: '/waf/ml_policy/import_data',
			type: 'post',
			dataType: 'json',
			beforeSubmit: function(formData, jqForm, options){
				// import button disable
				$j('.ui-dialog-buttonpane').find('button:first').attr("disabled", "disabled");
				if(formData[0].value == "") {
					alert($j.getInfo("err_import_file"));
					return false;
				}
				else{
					return true;
				}
			},
			success: function(responseText, statusText, xhr, $form){
				if(responseText.status == 1)
				{
					// $j('#progress_dialog').dialog('open');
					// check_import($j('#import_id').val());
					$j('#result_msg').text($j.getInfo('import_success'));
					$j('#result_dialog').dialog('open');
				}
				else if(responseText.status == 0)
					error_handler(responseText.msg_id);

				$j('.ui-dialog-buttonpane').find('button:first').removeAttr("disabled");
				$j("#import_dialog").dialog('close');
			},
			error: function(responseText, error){
				alert($j.getInfo("err_import"));
				$j('.ui-dialog-buttonpane').find('button:first').removeAttr("disabled");
				$j("#import_dialog").dialog('close');
			}
		};
		$j("#import_form").ajaxSubmit(options);
	}
	function clickCancel() {
		$j("#import_dialog").dialog('close');
	}
})

function export_data(id) {
	$j('#progress_dialog').dialog('option', 'title', $j.getInfo('export_dialog'));
	$j('#progressbar').progressbar('value', 0);
	$j.ajax({
		'url': '/waf/ml_policy/export_data?id='+id+'&type=1&session_id='+session_id,
		'dataType': 'json',
		'success': function(response)
		{
			if(response.status == 1)
			{
				// $j('#progress_dialog').dialog('open');
				// check_export(id);
				$j('#result_msg').text($j.getInfo('export_success'));
				$j('#result_dialog').dialog('open');
				var file = response.filename.split('/').pop();
				document.location.href = '/waf/ml_policy/export_download?msg=61&session_id=' + session_id + '&name=' + file;
			}
			else if(response.status == 0)
				error_handler(response.msg_id, '/waf/ml_policy/list');
		},
		'cache': false
	});
}

function import_data(id) {
	$j('#progress_dialog').dialog('option', 'title', $j.getInfo('import_dialog'));
	$j('#progressbar').progressbar('value', 0);
	$j('#import_id').val(id);
	$j("#import_dialog").dialog('open');
}

// function check_export(id) {
// 	$j.ajax({
// 		'url': '/waf/ml_policy/export_query?id='+id+'&type=1&session_id='+session_id,
// 		'dataType': 'json',
// 		'success': function(response)
// 		{
// 			if(response.status == 1)
// 			{
// 				// $j('.progress_label').text($j.getInfo('exporting')+' '+response.percent+'%');
// 				$j('#progressbar').progressbar( 'value', response.percent );
// 				if(response.percent == 100 && response.filename) {
// 					// $j('#progress_dialog').dialog( 'option', 'buttons', [{
// 					// 	text: $j.getInfo('close'),
// 					// 	click: function() {
// 					// 		$j('#progress_dialog').dialog('close')
// 					// 	}
// 					// }]);
// 					setTimeout(function() {
// 						$j('#progress_dialog').dialog('close');
// 						$j('#result_msg').text($j.getInfo('export_success'));
// 						$j('#result_dialog').dialog('open');
// 						var file = response.filename.split('/').pop();
// 						document.location.href = '/waf/ml_policy/export_download?msg=61&session_id=' + session_id + '&name=' + file;
// 					}, 500);
// 					return;
// 				}
// 				setTimeout(function() {
// 					check_export(id);
// 				}, 200);
// 			}
// 			else if(response.status == 0)
// 				error_handler(response.msg_id, '/waf/ml_policy/list');
// 		},
// 		'cache': false
// 	});
// }

// function check_import(id) {
// 	$j.ajax({
// 		'url': '/waf/ml_policy/import_query?id='+id+'&type=1&session_id='+session_id,
// 		'dataType': 'json',
// 		'success': function(response)
// 		{
// 			if(response.status == 1)
// 			{
// 				// $j('.progress_label').text($j.getInfo('importing')+' '+response.percent+'%');
// 				$j('#progressbar').progressbar( 'value', response.percent );
// 				if(response.percent == 100) {
// 					setTimeout(function() {
// 						$j('#progress_dialog').dialog('close');
// 						$j('#result_msg').text($j.getInfo('import_success'));
// 						$j('#result_dialog').dialog('open');
// 					}, 500);
// 					// $j('#progress_dialog').dialog( 'option', 'buttons', [{
// 					// 	text: $j.getInfo('close'),
// 					// 	click: function() {
// 					// 		$j('#progress_dialog').dialog('close')
// 					// 	}
// 					// }]);
// 					return;
// 				}
// 				setTimeout(function() {
// 					check_import(id);
// 				}, 200);
// 			}
// 			else if(response.status == 0)
// 				error_handler(response.msg_id, '/waf/ml_policy/list');
// 		},
// 		'cache': false
// 	});
// }

var del_type = 0; //for delete type
var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data) ? $j.getInfo('enable',flt_lang) : $j.getInfo('disable',flt_lang);
	}
	function status_lang_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		return (data) ? $j.getInfo('running', flt_lang) : $j.getInfo('stopped', flt_lang);
	}
	function action_format_fn(td, col, row_data)
	{
		var html = '';
		var expt = '';
		var impt = '';

		expt = '<a style="text-decoration: none;" id=\"export_data_btn\" onclick="export_data(\'' +row_data['policy-id']+ '\')">';
		expt += '<f-icon class="ftnt-export" title="'+$j.getInfo("export",fgt_lang)+'" style="cursor: pointer"></f-icon>';
		expt += '</a>';

		impt = '<a style="text-decoration: none;" id=\"import_data_btn\" onclick="import_data(\'' +row_data['policy-id']+ '\')">';
		impt += '<f-icon class="ftnt-import" title="'+$j.getInfo("import",fgt_lang)+'" style="cursor: pointer"></f-icon>';
		impt += '</a>';

		html = '<div>'+expt+' '+impt+'</div>';

		return html;
	}
	function gen_qlist(datas){
		
		var settings = {
			'prefix': 'waf_ml_policy',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
                {name: 'mkey', selector: 'id'},
                {name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'policy', 'lang_key': $j.getInfo('policy',flt_lang)},
				{'selector': 'sz_allow-domain-name', 'lang_key': $j.getInfo('domain_count',flt_lang)},
//				{'selector': 'hmm-engine', 'lang_key': $j.getInfo('hmm_engine',flt_lang)},
				{'selector': 'automatic-refresh-model', 'lang_key': $j.getInfo('automatic_refresh_model',flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo('status', flt_lang)},
				//{'selector': 'action', 'lang_key': $j.getInfo('action', flt_lang)},
			],
			'column_filters': {
				'enabled': false
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false,
				'hide_create_button': true
			},
            'callbacks': {
                'load': content_loaded
            },
			'default_columns':['id', 'policy', 'sz_allow-domain-name',/*'hmm-engine',*/'automatic-refresh-model', 'status', 'action'],
			'search': { 'enabled': false },
			'format_fn': {
//				'hmm-engine': lang_format_fn,
				'automatic-refresh-model': lang_format_fn,
				'status': status_lang_format_fn,
				//'action' : action_format_fn
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/waf/ml_policy/json', {_: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.results);
			} else {
				error_handler(results.msg_id, '/waf/ml_policy/list');
			}
		});
	}

	return {configure: configure};

})(jQuery);
