var module_list = (function($) {
	'use strict';

	function url_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		if(typeof(data) === 'undefined') return data;
		return data.replace(/,/g, "<br>");
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}
	function openapi_file_handle_selection_change(q)
    {
            qlist_handle_selection_change(q);

            var aElems = q.get_checked_rows();
            var mi_view = $("#mi_view_" + q.prefix);
            if(!is_rw_admin)
            {
                    qmenu_enable_button(mi_view, true, q);
                    return;
            }
            if (aElems.length == 1)
            {
                    qmenu_enable_button(mi_view, true, q);
            }else{
                    qmenu_enable_button(mi_view, false, q);
            }            
    }
	function gen_qlist(datas) {
		var menu_items = {};
        //if(is_rw_admin){
                menu_items = {
                        'mi_view': {
                                'id': 'mi_view',
                                'label': $.getInfo('view_details',flt_lang),
                                'class': 'tool_view',
                                'handler': edit_click,
                        }
                };
        //}

		var settings = {
			'prefix': 'waf_openapi_schema_file',
			'source': datas,
			'handle_selection_change': openapi_file_handle_selection_change,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
				{'selector': 'title', 'lang_key': $j.getInfo('title', flt_lang) },
				{'selector': 'desc', 'lang_key': $j.getInfo('desc', flt_lang) },
				{'selector': 'url', 'lang_key': $j.getInfo('url', flt_lang) },
//				{'selector': 'file-name', 'lang_key': $j.getInfo('file_name', flt_lang) },
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'hide_edit_button': true,
				'ref_column': false,
				'sorting': false
			},
			'default_columns': ['id', 'name', 'title', 'desc', 'url'],
			'row_attr': [
				{ name: 'name', selector: 'name' },
				{ name: 'q_ref', selector: 'q_ref' },
			],
			'format_fn': {
				'url': url_format_fn
			},
			'callbacks': {
				'load': content_loaded,
				'dblclick': edit_click
			}
		};

		var $container = $("#content");
		$container.qlist(settings);
	}

	function configure() {
		$j.getJSON('/waf/openapi_schema_file/json', { _: new Date().getTime() }, function(results) {
			if (results.status == 1) {
				gen_qlist(results.results);
			} else {
				error_handler(results.msg_id, "/waf/openapi_schema_file/list");
			}
		});
	}

	return { configure: configure };

})(jQuery);
