var module_list = (function($) {
	'use strict';

	var source;

	function lang_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
		var th_len = $('table thead tr th').length;

		$('table tbody tr').first().before(
			"<tr id=\"tr_session_management\" style=\"background-color: #FFD710\" valign=\"middle\"><td colspan=\""+th_len+"\">"
			+"<img id=\"wij_modal_close_btn_fixed\" src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
			+" onclick=\"document.getElementById('tr_session_management').style.display='none';\">"
			+$j.getInfo("need_session_management", fgt_lang)+"</td></tr>");
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'page_access',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'page-severity', 'lang_key': $j.getInfo("severity",flt_lang)},
			{'selector': 'page-trigger', 'lang_key': $j.getInfo("trigger",flt_lang)},
			{'selector': 'sz_page-access-list', 'lang_key': $j.getInfo("count",flt_lang)},
			],
			'default_columns':['id', 'name', 'page-severity', 'page-trigger', 'sz_page-access-list'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'page-severity': lang_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/page_access/list?vdom="+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
