var module_list = (function($) {
	'use strict';

	var source;
	var action_lang = {
		'alert' : 'alert',
		'alert_deny' : 'alert_deny',
		'deny_no_log': 'deny_no_log',
		'redirect' : 'redirect',
		'block-period' : 'period_block',
		'send_403_forbidden' : 'send_403_forbidden'
	};
	var severity_lang = {
		'High' : 'High',
		'Medium' : 'Medium',
		'Low' : 'Low',
		'Info': 'Info'
	};

	function option_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var options_lang = null;
		if(col.selector == 'action')
			options_lang = action_lang;
		else if(col.selector == 'severity')
			options_lang = severity_lang;
		else
			return '';

		var lang = options_lang[data] ? options_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,fgt_lang);
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function inputrule_handle_selection_change(q)
	{
		// Let the default handler handle the standard buttons.
		qlist_handle_selection_change(q);

		var mi_action = $("#mi_action_" + q.prefix);
		var mi_trigger = $("#mi_trigger_" + q.prefix);
		var mi_severity = $("#mi_severity_" + q.prefix);
		var mi_action_sub = $("#mi_action_drop_" + q.prefix);
		var mi_trigger_sub = $("#mi_trigger_drop_" + q.prefix);
		var mi_severity_sub = $("#mi_severity_drop_" + q.prefix);

		var aElems = q.get_checked_rows();

		var can_edit = true;
		var len = aElems.length;
		for (var i = 0; i < len; i++) {
			can_edit &= q.can_edit_fn(q, aElems[i]);
		}

		if(is_rw_admin && aElems.length > 0 && can_edit)
		{
			qmenu_enable_button(mi_action, true, q);
			qmenu_enable_button(mi_trigger, true, q);
			qmenu_enable_button(mi_severity, true, q);
			qmenu_enable_button(mi_action_sub, true, q);
			qmenu_enable_button(mi_trigger_sub, true, q);
			qmenu_enable_button(mi_severity_sub, true, q);
		}
		else
		{
			qmenu_enable_button(mi_action, false, q);
			qmenu_enable_button(mi_trigger, false, q);
			qmenu_enable_button(mi_severity, false, q);
			qmenu_enable_button(mi_action_sub, false, q);
			qmenu_enable_button(mi_trigger_sub, false, q);
			qmenu_enable_button(mi_severity_sub, false, q);
		}

		return;
	}

	function inputrule_onclick_action(q)
	{
		setTimeout(function() {
			$("#mi_action_drop_" + q.prefix).trigger('click');
		}, 10);
	}

	function inputrule_onclick_sub_action(q)
	{
		var action_id = this.id.split("mi_action_")[1];
		var url = "/waf/input_rule/change?type=1&action="+action_id+"&session_id="+session_id+"&vdom="+vdom;
		var aElems = q.get_checked_rows();
		if (aElems.length < 1) return;

		for(var i = 0 ; i < aElems.length ; i++)
		{
			url += "&mkey=" + aElems[i].getAttribute("mkey");
		}
		$.submitPOST(url);
	}

	function inputrule_onclick_trigger(q)
	{
		setTimeout(function() {
			$("#mi_trigger_drop_" + q.prefix).trigger('click');
		}, 10);				
	}

	function inputrule_onclick_sub_trigger(q)
	{
		var trigger_id = this.id.split("mi_trigger_")[1];
		var url = "/waf/input_rule/change?type=2&trigger="+trigger_id+"&session_id="+session_id+"&vdom="+vdom;
		var aElems = q.get_checked_rows();
		if (aElems.length < 1) return;

		for(var i = 0 ; i < aElems.length ; i++)
		{
			url += "&mkey=" + aElems[i].getAttribute("mkey");
		}
		$.submitPOST(url);
	}

	function inputrule_onclick_severity(q)
	{
		setTimeout(function() {
			$("#mi_severity_drop_" + q.prefix).trigger('click');
		}, 10);
	}

	function inputrule_onclick_sub_severity(q)
	{
		var severity_id = this.id.split("mi_severity_")[1];
		var url = "/waf/input_rule/change?type=3&severity="+severity_id+"&session_id="+session_id+"&vdom="+vdom;
		var aElems = q.get_checked_rows();
		if (aElems.length < 1) return;

		for(var i = 0 ; i < aElems.length ; i++)
		{
			url += "&mkey=" + aElems[i].getAttribute("mkey");
		}
		$.submitPOST(url);
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == 'undefined' ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang['global'])
			$.addLang();
		source = datas;

		var action_menu = [{text:'alert',val:'2'},{text:'alert_deny',val:'6'},{text:'deny_no_log', val:'4'},{text:'period_block',val:'11'},
			{text:'redirect',val:'3'},{text:'send_403_forbidden',val:'10'}];

		var severity_menu = [{text:'High',val:'1'},{text:'Medium',val:'2'},{text:'Low',val:'3'},{text:'Info',val:'4'}];

		var menu_items = {};
		if(is_rw_admin)
		{
			menu_items = {
				'mi_action': {
					'id': 'mi_action',
					'ctxt': false,
					'class': 'tool_sprite tool_edit',
					'handler': inputrule_onclick_action,
					'label': $.getInfo('edit_action',flt_lang),
					'submenu': {}
				},
				'mi_trigger': {
					'id': 'mi_trigger',
					'ctxt': false,
					'class': 'tool_sprite tool_edit',
					'handler': inputrule_onclick_trigger,
					'label': $.getInfo('edit_trigger',flt_lang),
					'submenu': {}
				},
				'mi_severity': {
					'id': 'mi_severity',
					'ctxt': false,
					'class': 'tool_sprite tool_edit',
					'handler': inputrule_onclick_severity,
					'label': $.getInfo('edit_severity',flt_lang),
					'submenu': {}
				}
			};

			var i = 0;
			for(i = 0; i < action_menu.length ; i++){
				menu_items['mi_action']['submenu']["mi_action_"+action_menu[i].val] = {
					'id': "mi_action_"+action_menu[i].val,
					'ctxt': false,
					'handler': inputrule_onclick_sub_action,
					'label': $.getInfo(action_menu[i].text,fgt_lang)
				};
			}
			for(i = 0; i < trigger_policy.length ; i++){
				menu_items['mi_trigger']['submenu']["mi_trigger_"+trigger_policy[i].value] = {
					'id': "mi_trigger_"+trigger_policy[i].value,
					'ctxt': false,
					'handler': inputrule_onclick_sub_trigger,
					'label': trigger_policy[i].text
				};
			}
			for(i = 0; i < severity_menu.length ; i++){
				menu_items['mi_severity']['submenu']["mi_severity_"+severity_menu[i].val] = {
					'id': "mi_severity_"+severity_menu[i].val,
					'ctxt': false,
					'handler': inputrule_onclick_sub_severity,
					'label': $.getInfo(severity_menu[i].text,fgt_lang)
				};
			}
		}

		var qlist_settings = {
			'prefix': 'waf_param_vali_rule',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $.getInfo('name',flt_lang)},
			{'selector': 'host', 'lang_key': $.getInfo('host',flt_lang)},
			{'selector': 'request-file', 'lang_key': $.getInfo('url',flt_lang)},
			{'selector': 'action', 'lang_key': $.getInfo('action',fgt_lang)},
			{'selector': 'severity', 'lang_key': $.getInfo('severity',fgt_lang)},
			{'selector': 'trigger', 'lang_key': $.getInfo('trigger',flt_lang)},
			{'selector': 'sz_rule-list', 'lang_key': $.getInfo('count',flt_lang)}
			],
			'default_columns':['id', 'name', 'host', 'request-file', 'action', 'severity', 'trigger', 'sz_rule-list'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
				'resize_to_parent': true,
			},
			'callbacks': {
				'load': content_loaded
			},
			'paging': {
				enabled: true, 
				page_lines: 100,
				show_all_button: true
			},
			'format_fn': {
				'action': option_format_fn,
				'severity': option_format_fn,
				'request-file': html_encode_format_fn
			},
			'handle_selection_change': inputrule_handle_selection_change,
		};

		var $container = $('#content');
		$container.qlist(qlist_settings);

	}

	function configure () {
		$.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/input_rule/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
