var module_list = (function($) {
        'use strict';

	var source = [];
        function content_loaded(qlist) {
		$('td').css('break-word', 'break-all');
	}

	function setup_qlist() {
		$.ajax({
			'url': '/waf/stage_signature/json?_=' + new Date().getTime(),
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.datas;
					gen_qlist();
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/waf/stage_signature/list");
			},
			'cache': false
		});
        }

	function disable_global(q, rows) {
		var url = '/waf/stage_signature/disable_global';

		url = qlist_url_append_arg(url, "session_id", session_id);
		for(var i = 0; i < rows.length; i++)
		{
			var sig_id = rows[i].getAttribute("signature_id") || 0;
			url = qlist_url_append_arg(url, "sig_id", sig_id);
		}

		$j.submitPOST(url);
	}

	function apply_local(q, rows) {
		var url = '/waf/stage_signature/local_action';

		url = qlist_url_append_arg(url, "session_id", session_id);
		for(var i = 0; i < rows.length; i++)
		{
			var sig_id = rows[i].getAttribute("signature_id") || 0;
			url = qlist_url_append_arg(url, "sig_id", sig_id);
		}

		$j.submitPOST(url);
	}

	function undo(q, rows) {
		var url = '/waf/stage_signature/undo';

		url = qlist_url_append_arg(url, "session_id", session_id);
		for(var i = 0; i < rows.length; i++)
		{
			var sig_id = rows[i].getAttribute("signature_id") || 0;
			url = qlist_url_append_arg(url, "sig_id", sig_id);
		}

		$j.submitPOST(url);
	}

	function qlist_onselect(q, rows) {
		rows = q.get_checked_rows();
		if (rows.length > 0) {
			qmenu_enable_button($("#mi_disable_global_waf_stage_signature"), true, q);
			qmenu_enable_button($("#mi_apply_local_waf_stage_signature"), true, q);
			qmenu_enable_button($("#mi_undo_waf_stage_signature"), true, q);
		}
		else
		{
			qmenu_enable_button($("#mi_disable_global_waf_stage_signature"), false, q);
			qmenu_enable_button($("#mi_apply_local_waf_stage_signature"), false, q);
			qmenu_enable_button($("#mi_undo_waf_stage_signature"), false, q);
		}

		var all_unapplied = true, all_applied = true;
		for(var i = 0; i < rows.length; i++)
		{
			var status = rows[i].getAttribute('status') || 0;
			if(status != 0)
				all_unapplied = false;
			if(status == 0)
				all_applied = false;
		}
		if(all_unapplied)
			qmenu_enable_button($("#mi_undo_waf_stage_signature"), false, q);
		if(all_applied)
		{
			qmenu_enable_button($("#mi_apply_local_waf_stage_signature"), false, q);
			qmenu_enable_button($("#mi_disable_global_waf_stage_signature"), false, q);
		}

		return qlist_handle_selection_change(q);
	}

	function desc_format_fn(td, col, row_data)
	{
		td.addClass('left');
		td.css('word-break', 'break-all');
		td.css('white-space', 'normal');
		var value = (row_data[col.selector] || '');
		return value;
	}

	function status_format_fn(td, col, row_data)
	{
		var val = row_data[col.selector] || 0;
		td.css('width', '170px');
		td.css('text-align', 'left');
		td.css('padding-left', '90px');
		var str = '';
		if(val == 0)
			str = '<img src="/images/status_tb_red.png" title="' + $.getInfo('unapplied') + '" />&nbsp;' + $.getInfo('unapplied');
		else if(val == 1 || val == 2)
			str = '<img src="/images/status_tb.png" title="' + $.getInfo('applied') + '" />&nbsp;' + $.getInfo('applied');
		//else if(val == 2)
		//	str = $.getInfo('disabled');
		return str;
	}

	function gen_qlist(){
                if (!window.fgt_lang || !fgt_lang["global"])
                        $.addLang();

		var menu_items = {};
		if(is_rw_admin)
		{
			menu_items["mi_disable_global"] = {
				'ctxt' : true,
				"class" : "tool_disable",
				"label" : $.getInfo("disable_global"),
				"handler" : disable_global
			};
			
			menu_items["mi_apply_local"] = {
				'ctxt' : true,
				"class" : "tool_apply",
				"label" : $.getInfo("apply_local"),
				"handler" : apply_local
			};
			menu_items["mi_undo"] = {
				'ctxt': true,
				'class': 'tool_undo',
				'label': $.getInfo('undo'),
				'handler': undo
			};
		}

                var qlist_settings = {
                        'prefix': 'waf_stage_signature',
                        'source': source,
			'menu_items': menu_items,
			'categories': ['category'],
			'row_attr': [
				{'name': 'signature_id', 'selector': 'signature_id'},
				{'name': 'status', 'selector': 'status'},
			],
                        'columns': [
                                {'selector': 'id', 'lang_key': '#'},
                                {'selector': 'signature_id', 'lang_key': 'Signature ID'},
				{'selector': 'desc', 'lang_key': $.getInfo('desc')},
                                {'selector': 'status', 'lang_key': $.getInfo('status')},
                        ],
                        'default_columns': ['id', 'signature_id', 'desc', 'status'],
                        'callbacks': {
                                'load': content_loaded
                        },
                        'options': {
                                'hide_default_buttons': true,
				'collapsible_categories': {'*': false},
				//'resizable_columns':true,
				'fixed_header': false
                        },
                        'format_fn': {
				'desc': desc_format_fn,
				'status': status_format_fn
                        },
			'handle_selection_change': qlist_onselect
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);
        }
        return {configure: setup_qlist};

})(jQuery);
