var module_list = (function($) {
	'use strict';
	function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data);
	}

	function handle_selection_change(q)
	{
		qlist_handle_selection_change(q);

		var aElems = q.get_checked_rows();
		var mi_edit = $("#mi_edit_" + q.prefix);
		var mi_view = $("#mi_view_" + q.prefix);

		if (aElems.length == 1 && parseInt(qlist_get_row_attr(aElems[0], 'default_flag')) == 1)
		{
			qmenu_enable_button(mi_view, true, q);
			qmenu_enable_button(mi_edit, false, q);
		}else{
			qmenu_enable_button(mi_view, false, q);
		}
	}

	function gen_qlist(datas){

		var menu_items = {};
		if(is_rw_admin){
			menu_items = {
				'mi_view': {
					'id': 'mi_view',
					'label': $.getInfo('view',fgt_lang),
					'class': 'tool_view',
					'handler': edit_click,
				}
			};
		}
		
		var settings = {
			'prefix': 'waf_tcp_flood_prevention',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'menu_items': menu_items,
			'handle_selection_change': handle_selection_change,
			'row_attr': [
                {name: 'mkey', selector: 'name'},
                {name: 'q_ref', selector: 'q_ref'},
                {name: 'default_flag', selector: 'can_view'}
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name',flt_lang)},
				{'selector': 'layer4-connection-threshold', 'lang_key': $j.getInfo('layer4_conn_threshold',flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo('action',flt_lang)},
				{'selector': 'severity', 'lang_key': $j.getInfo('severity',flt_lang)},
				{'selector': 'trigger-policy', 'lang_key': $j.getInfo('triggerAction',flt_lang)},

			],
			'column_filters': {
				'enabled': true,
                'exempts': ['id', 'name', 'layer4-connection-threshold', 'action', 'severity', 'trigger-policy']
			},
			'paging': {
				'enabled': false,
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
            'callbacks': {
                'load': content_loaded
            },
			'default_columns':['id', 'name', 'layer4-connection-threshold', 'action', 'severity', 'trigger-policy'],
			'search': { 'enabled': false },
			'format_fn': {
				'action': lang_format_fn,
				'severity': lang_format_fn,
			}
		};

		var $container = $("#content");
		
		$container.qlist(settings);
	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()},function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, '/waf/waf_tcp_flood_prevention/list?vdom='+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
