var module_list = (function($) {
        'use strict';

        var source;

        function setup_qlist()
        {
                $.ajax({
                        'url': '/waf/user_tracking_rule/list/json?table_gid='+g_cmdb_table_id+'&vdom='+vdom,
                        'dataType': 'json',
                        'success': function(response)
                        {
                                if(response.status == 1)
                                {
                                        source = response.datas;
                                        gen_qlist();
                                }
                                else if(response.status == 0)
                                        error_handler(response.msg_id, "/waf/user_tracking_rule/list");
                        },
                        'cache': false
                });
        }

        function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
                var th_len = $('table thead tr th').length;
		$('table tbody tr').first().before(
				"<tr id=\"tr_tip_offline\" style=\"background-color: #FFD710\" valign=\"middle\"><td colspan=\""+th_len+"\">"
				+"<img id=\"wij_modal_close_btn_fixed\" src=\"/images/x_small.gif\" style=\"right: 4px; position: fixed; cursor: pointer; \""
				+" onclick=\"document.getElementById('tr_tip_offline').style.display='none';\">"
				+$j.getInfo("tip_offline", flt_lang)+"</td></tr>");
        }

        function action_format_fn(td, col, row_data){
                var action = row_data["default-action"];
                var html = $j.getInfo(action, flt_lang);

                return html;
         }

        function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function gen_qlist(){
                var qlist_settings = {
                        'prefix': 'ca_group',
                        'source': source,
                        'cr_new_url': create_url,
                        'cr_edit_url': edit_url,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
				{'selector': 'seq', 'lang_key': '#'},
                                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
                                {'selector': 'host-status', 'lang_key': $j.getInfo("host_status",flt_lang)},
                                {'selector': 'hostname-ip', 'lang_key': $j.getInfo("host",flt_lang)},
                                {'selector': 'authentication-url', 'lang_key': $j.getInfo("authentication_url",flt_lang)},
                                {'selector': 'username-parameter', 'lang_key': $j.getInfo("username",flt_lang)},
                                {'selector': 'password-parameter', 'lang_key': $j.getInfo("password",flt_lang)},
                                {'selector': 'default-action', 'lang_key': $j.getInfo("default_action",flt_lang)},				
                                {'selector': 'sz_match-condition', 'lang_key': $j.getInfo("count",flt_lang)},
                                {'selector': 'session-id-name', 'lang_key': $j.getInfo("ssid_name",flt_lang)},
                                {'selector': 'logoff-path', 'lang_key': $j.getInfo("log_off_path",flt_lang)},
                                {'selector': 'session-timeout', 'lang_key': $j.getInfo("session_timeout",flt_lang)},
                                {'selector': 'session-fixation-protection', 'lang_key': $j.getInfo("session_fixation_protection",flt_lang)},
                                {'selector': 'session-timeout-enforcement', 'lang_key': $j.getInfo("session_timeout_enforcement",flt_lang)},
				{'selector': 'credential-stuffing-protection', 'lang_key': $j.getInfo("credential_protection",flt_lang)}
                        ],
                        'default_columns':['seq', 'name', 'host-status', 'hostname-ip', 'authentication-url', 'username-parameter', 'password-parameter', 'default-action', 'sz_match-condition'],
                        'column_filters': {
                                'enabled': true,
                                'exempts': ['seq', 'name', 'host-status', 'username-parameter', 'password-parameter', 'default-action', 'sz_match-condition', 'session-fixation-protection', 'session-timeout-enforcement', 'credential-stuffing-protection']
                        },
                        'callbacks': {
                                'load': content_loaded
                        },
                        'format_fn': {
                                'default-action': action_format_fn,
                                'host-status': lang_format_fn,
                                'session-fixation-protection': lang_format_fn,
				'session-timeout-enforcement': lang_format_fn,
				'credential-stuffing-protection': lang_format_fn
                        }
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
