var module_list = (function($) {
	'use strict';

	var source;

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		source = datas;

		var qlist_settings = {
			'prefix': 'web_cache_policy',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
			{'selector': 'cache-buffer-size', 'lang_key': $j.getInfo('cache_buffer_size', flt_lang)},
			{'selector': 'max-cached-page-size', 'lang_key': $j.getInfo('max_cache_page_size', flt_lang)},
			{'selector': 'default-cache-timeout', 'lang_key': $j.getInfo('def_cache_timeout', flt_lang)},
			{'selector': 'exception', 'lang_key': $j.getInfo('exception', flt_lang)},
			{'selector': 'sz_url-match-list', 'lang_key': $j.getInfo("count",flt_lang)},
			],
			'default_columns':['id', 'name', 'cache-buffer-size', 'max-cached-page-size', 'default-cache-timeout', 'exception', 'sz_url-match-list'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': false,
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom,_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/web_cache_policy/list?vdom="+vdom);
			}
		});
	}

	return {configure: configure};

})(jQuery);
