var module_list = (function($) {    
    'use strict';

    var source;

    function content_loaded(qlist) {
        qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    }

    function status_format_fn(td, col, row_data) {
        var data = row_data[col.selector];
        return (data === "enable") ? $j.getInfo('enable', flt_lang) : $j.getInfo('disable', flt_lang);
    }

    function lang_format_fn(td, col, row_data) {
        var data = row_data[col.selector];
        return (data === "") ? data : $j.getInfo(data, fgt_lang);
    }

    function gen_qlist(datas) {
        if (!window.fgt_lang || !fgt_lang["global"])
            $j.addLang();
        source = datas;

        var qlist_settings = {
            'prefix': 'waf_web_socket_rule',
            'source': source,
            'cr_new_url': create_url,
            'cr_edit_url': edit_url,
            'row_attr': [
                { name: 'mkey', selector: 'name' },
                { name: 'q_ref', selector: 'q_ref' },
            ],
            'columns': [
                { 'selector': 'id', 'lang_key': '#' },
                { 'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang) },
                { 'selector': 'host', 'lang_key': $j.getInfo("host", flt_lang) },
                { 'selector': 'url', 'lang_key': $j.getInfo("url", flt_lang) },
                { 'selector': 'block-websocket-traffic', 'lang_key': $j.getInfo("disallow_websocket", flt_lang) },
                { 'selector': 'action', 'lang_key': $j.getInfo("action", flt_lang) },
                { 'selector': 'max-frame-size', 'lang_key': $j.getInfo("max_frame_size", flt_lang) },
                { 'selector': 'max-message-size', 'lang_key': $j.getInfo("max_message_size", flt_lang) },
                { 'selector': 'block-extensions', 'lang_key': $j.getInfo("disallow_extensions", flt_lang) },
                { 'selector': 'enable-attack-signatures', 'lang_key': $j.getInfo("detection_signatures", flt_lang) }
            ],
            'default_columns': ['id', 'name', 'host', 'url', 'block-websocket-traffic'],
            'column_filters': {
                'enabled': false
            },
            'options': {
                'ref_column': false,
                'sorting': false,
            },
            'format_fn': {
                'block-websocket-traffic': status_format_fn,
                'action': lang_format_fn,
                'block-extensions': status_format_fn,
                'enable-attack-signatures': status_format_fn,
            },
            'callbacks': {
                'load': content_loaded
            }
        };

        var $container = $("#content");
        $container.qlist(qlist_settings);
    }

    function configure() {
        $j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, vdom: vdom, _: new Date().getTime() }, function(results) {
            if (results.status == 1) {
                gen_qlist(results.datas);
            } else {
                error_handler(results.msg_id, "/waf/web_socket_protocol_rule/list");
            }
        });
    }

    return { configure: configure };

})(jQuery);
