var module_list = (function($) {
	'use strict';

	function file_name_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		var index = data.lastIndexOf('/');
		var result = data.substring(index+1);
		return result;
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas) {
		var settings = {
			'prefix': 'waf_wsdl_file',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
//				{'selector': 'file-name', 'lang_key': $j.getInfo('file_name', flt_lang) },
			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'hide_edit_button': true,
				'ref_column': false,
				'sorting': false
			},
			'default_columns': ['id', 'name', 'file-name'],
			'row_attr': [
				{ name: 'mkey', selector: 'name' },
				{ name: 'q_ref', selector: 'q_ref' },
			],
			'format_fn': {
//				'file-name': file_name_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(settings);
	}

	function configure() {
		$j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, _: new Date().getTime() }, function(results) {
			if (results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/wsdl_file/list");
			}
		});
	}

	return { configure: configure };

})(jQuery);
