var module_list = (function($) {
	'use strict';

	function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
		var html = "";
		var text = ((data === "" ) ? data : $j.getInfo(data, fgt_lang));
		var sts_key = [col.selector.split('-')[0], "security", "status"].join('-');
		var sts_color = ((row_data[sts_key] == "enable") ? "green" : "grey");
	
		html = "<div align='left'>&emsp;&emsp;&emsp;&emsp;&emsp;<f-icon class='fa-circle "+ sts_color + "'></f-icon>&nbsp;" + text + "</div>";
		
		return html;
        }
	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas) {
		var settings = {
			'prefix': 'waf_xml_security_rule',
			'source': datas,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
				{'selector': 'xml-server-certificate', 'lang_key': $j.getInfo('server_cert', fgt_lang) },
				{'selector': 'xml-client-certificate-group', 'lang_key': $j.getInfo('client_cert', fgt_lang) },
				{'selector': 'request-operation', 'lang_key': $j.getInfo('request_action', fgt_lang) },
				{'selector': 'response-operation', 'lang_key': $j.getInfo('response_action', fgt_lang) },

			],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false
			},
			'default_columns': ['id', 'name', 'xml-server-certificate', 'xml-client-certificate-group', 'request-operation', 'response-operation'],
			'row_attr': [
				{ name: 'mkey', selector: 'name' },
				{ name: 'q_ref', selector: 'q_ref' },
			],
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'request-operation': lang_format_fn,
				'response-operation': lang_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(settings);
	}

	function configure() {
		$j.getJSON('/cli-direct-action', { table_gid: g_cmdb_table_id, vdom:vdom, _: new Date().getTime() }, function(results) {
			if (results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/waf/xml_security_rule/list");
			}
		});
	}

	return { configure: configure };

})(jQuery);
