
function show_detail(name){
	var qlistSubSlide;
	var create_sub_url = "/wvs/policy/detail?mkey=" + name;
	qlistSubSlide = new top.Sliderin({ 
		title: '',  
		url: create_sub_url,
		width: 995
	});
	qlistSubSlide.open();
}

var query_json = false;
var listTimeout;


var loading_dialog = (function($) {
	'use strict';
	function init(option)
	{
		$("#loading_dialog").dialog({
			resizable: false,
			width: 250,
			height: 70,
			autoOpen: false,
			draggable: false,
			modal: true,
			dialogClass: "fwb_loading_dialog"
		});
		$("#loading_dialog").dialog("option",option);
	}
	function show_dialog()
	{
		$("#loading_dialog").dialog("open");
	}
	function close_dialog()
	{
		$("#loading_dialog").dialog("close");
	}
	return {
		'init' : init,
		'show' : show_dialog,
		'hide': close_dialog
	};
})(jQuery);

var error_dialog = (function($) {
	'use strict';
	function init(option)
	{
		$j("#div_dialog").dialog({
			resizable: false,
			width: 400,
			autoOpen: false,
			modal: true
		});
		$j("#div_dialog").dialog("option",option);
	}
	function show_dialog(str)
	{
		$("#div_dialog").dialog("open");
		$("#dialog_msg").html(str);
	}
	function close_dialog()
	{
		$("#div_dialog").dialog("close");
	}
	return {
		'init' : init,
		'show' : show_dialog,
		'close': close_dialog
	};
})(jQuery);




//action ajax
function playAction(action_id,name){
	$j('<div id="loading_dialog" style="display:none;"><div id="loading"><img src="/theme/images/loading.gif"></img></div></div>').appendTo($j('body'));
	$j('<div id="div_dialog" style="display:none;"><div id="dialog_msg" style="line-height: 25px;padding: 10px 0;"></div></div>').appendTo($j('body'));

	query_json = true;

	loading_dialog.init({
		title: $j.getInfo("load_wait")
	});

	error_dialog.init({
		title: $j.getInfo("error_dialog_title"),
		buttons: [
			{
				text:$j.getInfo("ok"),
				click: function() {
					$j( this ).dialog("close");
				}
			}
		]
	});

	clearTimeout(listTimeout);
	$j.ajax({
	    url: '/wvs/policy/action/json',
		data : { "action_id" : action_id, "name": name},
	    dataType: "json",
	    cache: false,
	    success: function(results)
	    {
	        if(results.status == 1 && results.action_res == 1)
	        {
	        	module_list.getStatus();
	        }else{
	        	error_dialog.show($j.getInfo(results.msg_id));
			}
	   },
	    beforeSend: function () {
	    	loading_dialog.show();
	    },
	    complete: function () {
	    },
	    error: function() {
			error_dialog.show($j.getInfo(results.msg_id));
	    	loading_dialog.hide();
	    }
    });
}

var module_list = (function($) {
	'use strict';

	var source;

	

	function content_loaded(qlist) 
	{
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function status_format_fn($td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : $j.getInfo(data, flt_lang);
	}

	function get_action(status,name,session_id,is_schedule){
		var str = '';
		if(status == "done" || status == "stopped" || status == "failed"){
			str = '<f-icon class="ftntml ftntml-lg ftntml-view" style="margin-right:5;" title="' + $j.getInfo('show', flt_lang)+ '" onclick="show_detail(\''+ encodeURIComponent(name)+ '\');"></f-icon>';
			if(!is_schedule){
				str += '<f-icon class="ftntml ftntml-lg ftntml-repeat" title="' + $j.getInfo('repeat', flt_lang)+ '" onclick="playAction(1,\'' + name + '\');"></f-icon>';			
			}
		}else if(status == "scanning"){
			str = '<f-icon class="ftntml ftntml-lg ftntml-view" style="margin-right:5;"  title="' + $j.getInfo('show', flt_lang)+ '" onclick="show_detail(\''+ encodeURIComponent(name)+ '\');"></f-icon>';
			str += '<f-icon class="ftntml ftntml-lg ftntml-abort" title="' + $j.getInfo('stop', flt_lang)+ '" onclick="playAction(2,\'' + name + '\');"></f-icon>';
		}else if(status == "starting"){
			str = '';
		}
		return str;
	}


	function start_format_fn($td, col, row_data){
		var status = row_data['status'];
		var str = get_action(status,row_data['name'],row_data['session_id'],row_data['is_schedule']);
		return str;
	}

	

	function gen_qlist(datas) 
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		
		source = datas;

		var qlist_settings = {
			'prefix': 'wvs_policy',
    			'source': source,
    			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
			{name: 'mkey', selector: 'name'},
			{name: 'q_ref', selector: 'q_ref'},
			// {name: 'can_ed', selector: 'can_ed'}
			],
			'columns': [
			{'selector': 'id', 'lang_key': '#'},
			{'selector': 'name', 'lang_key': $j.getInfo("name", flt_lang)},
			{'selector': 'schedule', 'lang_key': $j.getInfo("schedule", flt_lang)},
			{'selector': 'profile', 'lang_key': $j.getInfo("profile", flt_lang)},
			{'selector': 'status', 'lang_key': $j.getInfo("status", flt_lang)},
			{'selector': 'action', 'lang_key': $j.getInfo("action", flt_lang)}
			],
			'default_columns': ['id', 'name', 'schedule', 'profile', 'status', 'action'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'ref_column': false,
				'sorting': false,
			},
			'format_fn': {
				// 'name': name_format_fn,
				'status' : status_format_fn,
				'action': start_format_fn
			},
			'callbacks': {
				'load': content_loaded
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}



	//ajax reload wvs policy status
	function getStatus(){
		$j.getJSON('/wvs/policy/list/json',{_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				if(query_json){
					loading_dialog.hide();
				}
				$j.each(results.datas,function(key,value){
					var status_text = (value.status === '') ? value.status : $j.getInfo(value.status, flt_lang);
					$j("#wvs_policy-qlist").find("tr").each(function(){
						if($j(this).attr("data-source-index") == key){
							var str = get_action(value.status,value.name,value.session_id,value.is_schedule);
							$j(this).children("td").eq(4).text(status_text);
							$j(this).children("td").eq(5).html(str);
						}
					})
				})
				// var p = new PeriodicalExecuter(getStatus, 10);
				listTimeout = setTimeout(getStatus,10000);
			}
			else
			{
				error_handler(results.msg_id, "/wvs/policy/list");
			}
		});
	}

	function configure() 
	{
		$j.getJSON('/wvs/policy/list/json',{_: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
				// var p = new PeriodicalExecuter(getStatus, 10);
				listTimeout = setTimeout(getStatus,10000);
			}
			else
			{
				error_handler(results.msg_id, "/wvs/policy/list");
			}
		});

	}

	return {
		configure: configure,
		getStatus: getStatus
	};
})(jQuery);
