var module_list = (function($) {
	'use strict';

	var source;

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return $j.getInfo(data, flt_lang);
	}

	function date_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var type = row_data['type'];
		var array = data.split(' ');

		if(type == 'onetime')
			return array[1];
		else
			return '';
	}

	function time_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var type = row_data['type'];
		var full_time;
		var array;
		var html = '';
		if(type == 'onetime'){
			full_time = row_data['date'];
			array = full_time.split(' ');
			html = array[0];
		}
		else
		{
			html = data;
		}

		return html;
	}

	function wday_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var type = row_data['type'];
		var array = data.split(' ');

		// every week day only use first 3 chars
		if(type == 'recurring')
		{
			return array.map(function(val) {
				return val?$j.getInfo("w_"+val.toLowerCase()):"";
				//return val.substring(0, 3);
			}).join(' ');
		}
		else
			return '';
	}

	function content_loaded(qlist) {
		qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
	}

	function gen_qlist(datas){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		source = datas;

		var qlist_settings = {
			'prefix': 'wvs_schedule',
			'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
			'row_attr': [
				{name: 'mkey', selector: 'name'},
				{name: 'q_ref', selector: 'q_ref'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo("type",flt_lang)},
				{'selector': 'time', 'lang_key': $j.getInfo("time", flt_lang)},
				{'selector': 'date', 'lang_key': $j.getInfo('date', flt_lang)},
				{'selector': 'wday', 'lang_key': $j.getInfo('day', flt_lang)}
			],
			'default_columns':['id', 'name', 'type', 'time', 'date', 'wday'],
			'column_filters': {
				'enabled': false
			},
			'options':{
				'ref_column': false,
				'sorting': true
			},
			'callbacks': {
				'load': content_loaded
			},
			'format_fn': {
				'type': type_format_fn,
				'date': date_format_fn,
				'wday': wday_format_fn,
				'time': time_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);

	}

	function configure () {
		$j.getJSON('/cli-direct-action', {table_gid:g_cmdb_table_id,vdom:vdom, _: new Date().getTime()}, function(results) {
			if(results.status == 1) {
				gen_qlist(results.datas);
			} else {
				error_handler(results.msg_id, "/wvs/schedule/list");
			}
		});
	}

	return {configure: configure};

})(jQuery);
