var module_list = (function($) {
        'use strict';
        function status_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data);
        }
        function location_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo('ip_location_'+data,flt_lang);
        }        
        var source;

        function setup_qlist()
        {
                $.ajax({
                        'url': '/cli-direct-action?table_gid='+g_cmdb_table_id+'&vdom=' + vdom,
                        'dataType': 'json',
                        'success': function(response)
                        {
                                if(response.status == 1)
                                {
                                        source = response.datas;
                                        gen_qlist();
                                }
                                else if(response.status == 0)
                                        error_handler(response.msg_id, "/waf/x_forwarded_for/list");
                        },
                        'cache': false
                });
        }

	function content_loaded(qlist) {
                qlist.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
        }

        function gen_qlist(){

		var qlist_settings = {
                        'prefix': 'x_forwarded_for',
                        'source': source,
			'cr_new_url': create_url,
			'cr_edit_url': edit_url,
                        'row_attr': [
                                {name: 'mkey', selector: 'name'},
                                {name: 'q_ref', selector: 'q_ref'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': '#'},
                                {'selector': 'name', 'lang_key': $j.getInfo("name",flt_lang)},
                                {'selector': 'x-forwarded-for-support', 'lang_key': $j.getInfo("x_forwarded_for_support",flt_lang)},
                                {'selector': 'x-real-ip', 'lang_key': $j.getInfo("x_real_ip",flt_lang)},
                                {'selector': 'sz_ip-list', 'lang_key': $j.getInfo('count', flt_lang)},
                                {'selector': 'x-forwarded-proto', 'lang_key': $j.getInfo("x_forwarded_for_proto",flt_lang)},
                                {'selector': 'tracing-original-ip', 'lang_key': $j.getInfo("tracing_original_ip",flt_lang)},
                                {'selector': 'ip-location', 'lang_key': $j.getInfo("ip_location",flt_lang)},
				{'selector': 'block-based-on-original-ip', 'lang_key': $j.getInfo("block_by_original_ip",flt_lang)}
                        ],
                        'default_columns':['id', 'name', 'x-forwarded-for-support', 'x-real-ip', 'sz_ip-list'],
                        'column_filters': {
                                'enabled': false,
                        },
//                        'handle_selection_change': selection_changed,
                        'callbacks': {
                                'load': content_loaded
                        },
                        'format_fn': {
                                'x-forwarded-for-support': status_format_fn,
                                'x-real-ip': status_format_fn,
                                'x-forwarded-proto': status_format_fn,
                                'tracing-original-ip': status_format_fn,
                                'ip-location': location_format_fn,
                                'block-based-on-original-ip': status_format_fn
                        }
                };

                var $container = $("#content");
                $container.qlist(qlist_settings);

        }

	return {configure: setup_qlist};

})(jQuery);
