/*
  filter.js - core JS code for filter dialogs. Imported from fgt_display.c
  init Jan. 2010 by J. Thompson
  GUI redesign project
  Copyright Fortinet Ltd
*/
/*Util.js*/
/*global setCookie, getCookie, serializeArray, deserializeArray,
setQueryValue, escapeHTML, RegExpCommon, disableElementsByName, alert_focus*/

/*fgt_display.c
thisForm is typically jQuery('[name=thisForm]'), can be set in different pages
*//*global
filterCookieName, filters, thisForm, filterExpaned, activeColour, inactiveColour*/

// TODO: when filterSetup is removed, merge this file into jquery.filterConsole.js
var FIELD_TYPE = {
    STRING: 0,
    INTEGER: 1,
    TIME: 2,
    DATE: 3,
    IP_HOST: 4,
    IP_RANGE: 5,
    PORT: 6,
    POLICY_ID: 7,
    EXPIRY: 8,
    PROTOCOL: 9,
    DATE_TIME: 10,
    IP_PORT_RANGE: 11,
    ENUM: 12
};
var FIELD_TYPE_STRINGS = Object.keys(FIELD_TYPE).reduce(function(result, ft) {
    'use strict';
    result[FIELD_TYPE[ft]] = ft.toLowerCase();
    return result;
}, []);

var DISPLAY_FILTER_TYPE_SELECT = 2,
    DISPLAY_FILTER_TYPE_SELECT_MULTIPLE = 3;

var FILTER_NAME_PRI = "pri";

// TODO: remove use of this global object
// Each qlist has its own copy of filter_settings
// identified by qlist id
var filter_settings = {};

// DEPRECATED - remove after merge of br_5_js_library_cleanup
function doOK(panel)
{
    var filterCookieArray = [];

    var err = 0;

    $j(panel).filterSection(
        function (flt) {
            var fltarray = filterValidate.call(this, flt);
            var newflt = null;

            if (!fltarray) {
                err = 1;
                return false;
            }
            if (true === fltarray) {
                fltarray=[flt];
            }
            for (var i = 0; i < fltarray.length; i++) {
                if (newflt = fltarray[i]) {
                    var filter = flt2DisplayFilter(newflt);
                    filter.enable = newflt.value && newflt.value.join("").length ? filter.enable : 0;
                    if (filter.enable)
                        filterCookieArray = setDisplayFilter(filterCookieArray, filter);
                    else
                        filterCookieArray = removeDisplayFilter(filterCookieArray, newflt.id);
                }
            }
        });

    if (err) return false;
    var filterValue = serializeArray(filterCookieArray);
    var url = setQueryValue(location.href, "start");
    if (!getParams({filter:null}).filter) {
        setCookie(filterCookieName, filterValue);
    } else {
        url = setQueryValue(url, 'filter', filterValue);
    }
    // reset to first page

    window.location = setQueryValue(url, "expanded", $j("input[name=expanded]", panel).val());

    return false;
}

// DEPRECATED - remove after merge of br_5_js_library_cleanup
//            - replace usage in filterValidate
function flt2DisplayFilter(flt, filter_setting_id)
{
    var col;
    var columns = filter_settings[filter_setting_id];
    // TODO: remove reliance on this global variable
    if (!columns) { return flt2DisplayFilter_obj(flt, filter_setting_id); }

    for (var i = 0; (col = columns[i]); i++)
        if (col[0] == flt.id) break;

    if (col == null) { return flt2DisplayFilter_obj(flt, filter_setting_id); }

    var fltType = col[2][0];
    return new DisplayFilter(
            flt.id,
            col[2][1],
            fltType,
            1,
            flt.logic.NOT ? 1 : 0,
            fltType == FIELD_TYPE.STRING || flt.logic.RANGE ? 1 : 0,
            0,
            flt.value);
}

// INTERNAL USE ONLY -- TODO: remove use of global filter_settings
function flt2DisplayFilter_obj(flt, filter_setting_id) {
    var col;
    var columns = filter_settings[filter_setting_id];

    // TODO: remove reliance on this global variable
    for (var i = 0; (col = columns[i]); i++) {
        if (col.key == flt.id) { break; }
    }
    // TODO: see if col === flt -> would solve the global variable issue
    var fltType = col._display_filter_type || FIELD_TYPE.STRING;
    return new DisplayFilter(
            flt.id,
            fltType,
            col._field_type,
            1,
            flt.logic.NOT ? 1 : 0,
            fltType == FIELD_TYPE.STRING || flt.logic.RANGE ? 1 : 0,
            0,
            flt.value);
}

var filterValidate = (function() {
    function valid_int(v) {
        var i = parseInt(v, 10);
        return !v || !isNaN(i);
    }

    function isRange(valstr, rex1, rex2) {
        //is this a value range: "val1-val2"
        if (rex2 === undefined) { rex2 = rex1; }
        if (valstr.indexOf('-') < 0) { return false; }
        var range = getRange(valstr);
        return rex1.test(range[0]) && rex2.test(range[1]);
    }

    function getRange(valstr/*, rex1, rex2*/) {
        // assert isRange(valstr, rex1, rex2) === true (when not called from within isRange)
        var splitstr = valstr.split('-');
        return [$j.trim(splitstr[0]), $j.trim(splitstr[1])];
    }

    var ipRegex = /^([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$/;
    var rangeRegex = /^([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5]|\*)){3}$/;
    var range2Regex = /^([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5])(\.([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5]|\[([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5])-([0-9][0-9]?|[0-1][0-9][0-9]|2[0-4][0-9]|25[0-5])\])){3}$/;
    var ipv6Regex = /^\s*\[?((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})))(%.+)?\]?\s*$/;
    var secondRegex = /^([1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$/;
    var fqdnRegex = /^\w+$/;
    var portRegex = /^([0-9]*)$/;
    function isIPRange3(valstr) {
        //is this an IP range: "x1.x2.x3.x4-y1.y2.y3.y4"
        return isRange(valstr, ipRegex);
    }
    var getIPRange3 = getRange;

    function isIPRange4(valstr) {
        //is this an IP range: "x1.x2.x3.x4-y4"
        return isRange(valstr, ipRegex, secondRegex);
    }
    function getIPRange4(valstr) {
        // assert isIPRange4(valstr) === true
        var ipvals = getRange(valstr);
        // construct a full ip address for the range's end by replacing the last octet
        var arr = ipvals[0].split('.');
        arr[3] = ipvals[1];
        return [ipvals[0],  arr.join('.')];
    }

    function isPortRange(valstr) {
        //is this a port range: "p1-p2"
        return isRange(valstr, portRegex);
    }

    function isPortOrRange(valstr) {
        //is this a port or port range?
        return portRegex.test(valstr) || isPortRange(valstr);
    }
    function getPortOrRange(valstr) {
        // assert isPortOrRange(valstr) === true
        if (valstr.indexOf('-') < 0) { return [valstr]; }
        return getRange(valstr);
    }
    function getPortFilter(flt, pvals) {
        //returns the port filter
        // assert isPortOrRange(valstr) === true
        var portflt = $j.extend(true, {}, flt);
        portflt.logic.RANGE = (1 < pvals.length) ? 1 : 0;
        portflt.value = pvals;
        return portflt;
    }

    function portSeparatorIndex(valstr) {
        //returns the index of the port notation separator (":"), or -1 if it does not exist
        if (ipv6Regex.test(valstr)) {
            return -1;
        }

        return valstr.lastIndexOf(':');
    }

    function dotted2num(dotted) {
        var dots = dotted.split(".");
        var vdots = [ +dots[0], +dots[1], +dots[2], +dots[3] ];

        // << operator assumes signed 32 bit, so we can't do << 24 without overflowing
        var vmask = (vdots[0] * (1<<24)) + (vdots[1] << 16) + (vdots[2] << 8) + vdots[3];

        return vmask;
    }

    function validate_ip_port_range(flt, f, filter, options) {
        if (options == null) { options = {}; }
        //performs validation for a filter representing an ip range
        //returns a filter array which can be empty to represent failed validation
        var fieldName = filter.fieldName;
        var fltaddr = $j.extend(true, {}, flt); //deep copy of filter object
        var port_string;
        var value_string;
        var arr = [], lo, hi, i, j;

        for (i = 0; (value_string = flt.value[i]); i++) {
            port_string = "";

            var ix = portSeparatorIndex(value_string);
            if (ix >= 0) {
                //split address:port info
                port_string = $j.trim(value_string.slice(ix + 1));
                value_string = $j.trim(value_string.slice(0, ix));
            }

            if (port_string) {
                if (options.forbid_ports) return false;
                if (!isPortOrRange(port_string)) {
                    //port validation fails
                    alert($j.getInfo("err_port"));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }
                port_string = ':' + port_string;
            }

            if (ipRegex.test(value_string)) {
                fltaddr.value[i] = value_string + port_string;
                continue;
            }
            else if (ipv6Regex.test(value_string)) {
                fltaddr.value[i] = value_string.replace(/^\[|\]$/g, '') + port_string;
                continue;
            }
            else if (rangeRegex.test(value_string)) {
                arr = value_string.split(".");
                lo = []; hi = [];
                for (j = 0; arr[j]; j++) {
                    lo.push(arr[j] == "*" ? "0" : arr[j]);
                    hi.push(arr[j] == "*" ? "255" : arr[j]);
                }
                fltaddr.logic.RANGE = 1;
                fltaddr.value = [lo.join(".") + port_string, hi.join(".")];
                break;
            }
            else if (range2Regex.test(value_string)) {
                arr = value_string.split(".");
                lo = []; hi = [];
                for (j = 0; arr[j]; j++) {
                    var range = arr[j].split("-");
                    lo.push(range.length == 2 ? range[0].substr(1) : arr[j]);
                    hi.push(range.length == 2 ? range[1].substr(0, range[1].length - 1) : arr[j]);
                }
                if (dotted2num(lo.join(".")) <= dotted2num(hi.join("."))) {
                    fltaddr.logic.RANGE = 1;
                    fltaddr.value = [lo.join(".") + port_string, hi.join(".")];
                    break;
                } else {
                    alert($j.getInfo("err_range"));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }
            }
            else if (isIPRange3(value_string)) {
                arr = getIPRange3(value_string);
                fltaddr.logic.RANGE = 1;
                fltaddr.value = [arr[0] + port_string, arr[1]];
                break;
            }
            else if (isIPRange4(value_string)) {
                arr = getIPRange4(value_string);
                fltaddr.logic.RANGE = 1;
                fltaddr.value = [arr[0] + port_string, arr[1]];
                break;
            }
            else if (i == 1 && secondRegex.test(value_string)) {
                arr = flt.value[0].split(".");
                arr[3] = value_string;
                fltaddr.logic.RANGE = 1;
                fltaddr.value[i] = arr.join(".");
                break;
            }
            else if (i === 0 && fqdnRegex.test(value_string)) {
                fltaddr.value[i] = value_string + port_string;
                continue;
            }
            else if (!value_string) {
                fltaddr.value[i] = value_string + port_string;
                continue;
            }

            //validation fails: invalid format
            alert($j.getInfo("err_iphost"));
            $j(f[fieldName + "_text_value"]).select().focus();
            return false;
        }

        // parse success
        if (fltaddr && fltaddr.value && fltaddr.value.join("")) {
            return [fltaddr];
        }

        //validation fails
        alert($j.getInfo("err_iphost"));
        $j(f[fieldName + "_text_value"]).select().focus();
        return false;
    }

    // TODO: deprecate this function and replace with jQuery validate rules
    function filterValidate(flt) {
        var f = $j(this).parents("form:first")[0];
        var filter_setting_id =  $j(this).closest('.qlist-container').data('config').prefix;

        var filter = flt2DisplayFilter(flt, filter_setting_id);

        var fieldName = filter.fieldName;

        var value_string, value_array;

        switch (filter.fieldType) {

        case FIELD_TYPE.PORT :
            for (var i = 0; (value_string = flt.value[i]); i++) {

                if (!RegExpCommon.RANGE_INT.test(value_string)) {
                    alert($j.getInfo('err_range_int'));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }

                value_array = value_string.split("-");
                if (!(isNaN(parseInt(value_array[0], 10)) ||
                            (parseInt(value_array[0], 10) >= 0) && (parseInt(value_array[0], 10) <= 65536)) ||
                        !(isNaN(parseInt(value_array[1], 10)) ||
                            (parseInt(value_array[1], 10) >= 0) && (parseInt(value_array[1], 10) <= 65536))) {
                    alert($j.getInfo('err_integer'));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }

                if (parseInt(value_array[0], 10) > parseInt(value_array[1], 10)) {
                    alert($j.getInfo('err_range'));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }

            }
            break;

        case FIELD_TYPE.POLICY_ID:
        case FIELD_TYPE.INTEGER:
            for (i = 0; (value_string = flt.value[i]); i++) {
                if (!valid_int(value_string)) {
                    return alert_focus(
                            f[fieldName + "_text_value"], $j.getInfo('err_int'));
                }
            }

            if (flt.logic.RANGE && parseInt(flt.value[0], 10) > parseInt(flt.value[1], 10))
                return alert_focus(
                    f[fieldName + "_text_value"], $j.getInfo('err_range'));

            break;

        case FIELD_TYPE.EXPIRY:
            for (i = 0; (value_string = flt.value[i]); i++) {

                if (!RegExpCommon.RANGE_INT.test(value_string)) {
                    alert($j.getInfo('err_range_int'));
                    /*only used in spamfiltermassmmslist.c*/
                    if (window.displayFilter) {
                        window.displayFilter(fieldName);
                    }
                    if (window.inputFields != null && window.inputFields[i] != null) {
                        window.inputFields[i].select();
                        window.inputFields[i].focus();
                    }
                    return false;
                }

                value_array = value_string.split("-");
                if (!(isNaN(parseInt(value_array[0], 10)) ||
                            (parseInt(value_array[0], 10) >= 0) && (parseInt(value_array[0], 10) <= 604800)) ||
                        !(isNaN(parseInt(value_array[1], 10)) ||
                            (parseInt(value_array[1], 10) >= 0) && (parseInt(value_array[1], 10) <= 604800))) {
                    alert($j.getInfo('err_range'));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }

                if (parseInt(value_array[0], 10) > parseInt(value_array[1], 10)) {
                    alert($j.getInfo('err_expiry'));
                    $j(f[fieldName + "_text_value"]).select().focus();
                    return false;
                }

            }
            break;

        // Validation of FIELD_TYPE.DATE_TIME.
        // The date & time format is :   yyyy/mm/dd hh:mm:ss
        // 1) '/' is the separator of date, because '-' is reserved for separator of range
        // 2) the format is very strict, because checking if the start time is
        //    later than end time is done by regular string comparision
        case FIELD_TYPE.DATE_TIME:

            var val_arr = flt.value[0].split(" ");

            if (val_arr[0] && !RegExpCommon.DATE.test(val_arr[0]))
                return alert_focus(f[fieldName + "_from_value"],
                                   $j.getInfo('err_date_time'));

            if (val_arr[1] && !RegExpCommon.TIME.test(val_arr[1]))
                return alert_focus(f[fieldName + "_from_value"],
                                   $j.getInfo('err_date_time'));

            val_arr = flt.value[1].split(" ");

            if (val_arr[0] && !RegExpCommon.DATE.test(val_arr[0]))
                return alert_focus(f[fieldName + "_to_value"],
                                   $j.getInfo('err_date_time'));

            if (val_arr[1] && !RegExpCommon.TIME.test(val_arr[1]))
                return alert_focus(f[fieldName + "_to_value"],
                                   $j.getInfo('err_date_time'));

            if (flt.logic.RANGE && flt.value[0] && flt.value[1] && flt.value[0] > flt.value[1]) {
                alert($j.getInfo('err_range_date_time'));
                $j("input[name=" + fieldName + "_from_value]").select().focus();
                return false;
            }

            break;

        case FIELD_TYPE.IP_HOST:
            return validate_ip_port_range(flt, f, filter, { forbid_ports: true });
        case FIELD_TYPE.IP_RANGE:
        case FIELD_TYPE.IP_PORT_RANGE:
            return validate_ip_port_range(flt, f, filter);

        case FIELD_TYPE.TIME:
            if (!RegExpCommon.TIME.test(flt.value[0])) {
                alert($j.getInfo('err_date_time'));
                $j("input[name=" + fieldName + "_from_value]").select().focus();
                return false;
            }
            if (!RegExpCommon.TIME.test(flt.value[1])) {
                alert($j.getInfo('err_date_time'));
                $j("input[name=" + fieldName + "_to_value]").select().focus();
                return false;
            }
            if (flt.logic.RANGE && flt.value[0] && flt.value[1] && flt.value[0] > flt.value[1]) {
                alert($j.getInfo('err_range'));
                $j("input[name=" + fieldName + "_from_value]").select().focus();
                return false;
            }
            break;

        case FIELD_TYPE.DATE:
            if (!RegExpCommon.DATE.test(flt.value[0])) {
                alert($j.getInfo('err_date_time'));
                $j("input[name=" + fieldName + "_from_value]").select().focus();
                return false;
            }
            if (!RegExpCommon.DATE.test(flt.value[1])) {
                alert($j.getInfo('err_date_time'));
                $j("input[name=" + fieldName + "_to_value]").select().focus();
                return false;
            }
            if (flt.logic.RANGE && flt.value[0] && flt.value[1] && flt.value[0] > flt.value[1]) {
                alert($j.getInfo('err_range'));
                $j("input[name=" + fieldName + "_from_value]").select().focus();
                return false;
            }
            break;
        }
        return true;
    }
    return filterValidate;
}).call(this);

// DEPRECATED - remove after merge of br_5_js_library_cleanup
function enableFilter(filterName, enabled)
{
    document.getElementById("option_" + filterName).style.color = enabled ? activeColour : inactiveColour;
    disableElementsByName(document.getElementById("div_" + filterName), ["input", "select", "option"], "^" + filterName + "_", !enabled);
}

// DEPRECATED - remove after merge of br_5_js_library_cleanup
//            - replace usage in filterValidate
function DisplayFilter(fieldName, filterType, fieldType, enable, negate, contains, case_sensitive, value)
{
    this.fieldName = fieldName;
    this.filterType = filterType;
    this.fieldType = fieldType;
    this.enable = enable;
    this.contains = contains;
    this.negate = negate;
    this.case_sensitive = case_sensitive;
    this.value = value;

    function toArray() {
        var filterArray = [this.fieldName, this.enable, this.negate, this.contains, this.case_sensitive, this.value];
        return filterArray;
    }
    this.toArray = toArray;
}

// DEPRECATED - remove after merge of br_5_js_library_cleanup
function setDisplayFilter(filterCookieArray, filter)
{
    if (!filter) return filterCookieArray;
    if (!filterCookieArray)
    {
        filterCookieArray = [];
    }

    for (var i = 0; i < filterCookieArray.length; i++)
    {
        if (filterCookieArray[i][0] == filter.fieldName)
        {
            filterCookieArray[i] = filter.toArray();
            return filterCookieArray;
        }
    }

    filterCookieArray[filterCookieArray.length] = filter.toArray();
    return filterCookieArray;
}

// DEPRECATED - remove after merge of br_5_js_library_cleanup
function removeDisplayFilter(filterCookieArray, fieldName)
{
    if (!filterCookieArray)
    {
        filterCookieArray = [];
    }

    for (var i = 0; i < filterCookieArray.length; i++)
    {
        if (filterCookieArray[i][0] == fieldName)
        {
            filterCookieArray.splice(i, 1);
            break;
        }
    }

    return filterCookieArray;
}

// convert filter columns list to filter console column list
// Column format is [
//      key:string,
//      label:string,
//      [FIELD_TYPE enum(number), DISPLAY_FILTER_TYPE enum(number)],
//      selection:{?}, // mostly unused
//      validate:function.call(jQuery arg,filterConsole object),  // mostly unused
//      display:?  // mostly unused
//      ]
// DEPRECATED: remove when filterSetup is removed
//             create your flt objects manually and pass to setFilterDetails,
//             and set filter_settings.columns explicitly
//                 (needed for flt2DisplayFilter, filterValidate and doOK)
function fieldColumnParse(columns)
{
    filter_settings.columns = columns;

    var cols = [];

    var col;
    for (var i = 0; (col = columns[i]); i++) {
        var flt = {
            "key": col[0],
            "is": {},
            "label": col[1],
            "selection": col[3],
            "validate": col[4],
            "display": col[5]
        };

        flt = setFilterDetails(flt, col[2][0], col[2][1]);

        cols.push(flt);
    }

    return cols;
}

function setFilterDetails(flt, field_type, display_filter_type) {
    // augments the 'flt' object with extra data based on
    // field_type(FIELD_TYPE.*) and display_filter_type(DISPLAY_FILTER_TYPE_*)

    // 'flt' should be of the form
    // {
    //     "key": string,
    //     "is": {},
    //     "label": string,
    //     "selection": array/array-like object,
    //     "validate": function.call(jQuery selector/DOM object, flt) => boolean (optional) // TODO: deprecate this option
    //                 /* flt is an object that can be passed to flt2DisplayFilter;
    //                    different (?) than the flt object passed to this function */
    //     "validateOpts": {options for jQuery.validate},  // TODO: implement this option
    //     "display": function(oflt) => any - generic callback for when the filter is displayed
    // }
    var override_support = null;
    if (flt.support) {
        override_support = $j.extend(true, {}, flt.support);
    }
    if (flt.validate == null) { flt.validate = filterValidate; }
    if (flt.is == null) { flt.is = {}; }
    flt._field_type = field_type;
    flt._display_filter_type = display_filter_type;

    // tags selection
    if (flt.selection) flt.is = $j.extend(flt.is, {"tags": flt.selection.tags});

    switch (field_type) {
        case FIELD_TYPE.DATE:
            if (typeof(flt.help) == "undefined") flt.help = $j.getInfo("format") + ": " + $j.datepicker._defaults.dateFormat.replace("yy", "yyyy");
            /* falls through */
        case FIELD_TYPE.DATE_TIME:
            if (typeof(flt.help) == "undefined") flt.help = $j.getInfo("format") + ": " + $j.datepicker._defaults.dateFormat.replace("yy", "yyyy") + " hh:mm:ss";
            flt.is = $j.extend(flt.is, {"date": 1});
            /* falls through */
        case FIELD_TYPE.TIME:
            if (typeof(flt.help) == "undefined") flt.help = $j.getInfo("format") + ": hh:mm:ss";
            flt.support = {"NOT": 1, "RANGE": 1};
            break;
        case FIELD_TYPE.IP_HOST:
        case FIELD_TYPE.IP_RANGE:
            if (typeof(flt.help) == "undefined") flt.help = $j.getInfo("helpIp") + "<br>" + $j.getInfo("helpText");
            flt.is = $j.extend(flt.is, {"ip": 1});
            /* falls through */
        case FIELD_TYPE.POLICY_ID:
        case FIELD_TYPE.PORT:
        case FIELD_TYPE.INTEGER:
            if (typeof(flt.help) == "undefined") flt.help = $j.getInfo("helpRange") + "<br>" + $j.getInfo("helpText");
            flt.support = {"NOT": 1, "OR": display_filter_type != DISPLAY_FILTER_TYPE_SELECT, "RANGE": 1};
            break;
        case FIELD_TYPE.IP_PORT_RANGE:
            flt.is = $j.extend(flt.is, {"ip": 1, "ipport": 1});
            if (typeof(flt.help) == "undefined") flt.help = $j.getInfo("helpIpPort1") + "<br>" + $j.getInfo("helpIpPort2");
            flt.support = {"RANGE": 1};
            break;
        default:
            if (!flt.selection && typeof(flt.help) == "undefined") flt.help = $j.getInfo("helpText");
            flt.support = {"NOT": 1, "OR": display_filter_type == DISPLAY_FILTER_TYPE_SELECT_MULTIPLE};
    }
    flt.support.is = flt.is;
    if (override_support) {
        $j.extend(true, flt.support, override_support);
    }
    return flt;
}

// convert current filter array to filter console array
// DEPRECATED: remove when filterSetup is removed
function fieldFilterParse(filterArray)
{
    var flts = [];

    var flt, oflt, i;
    for (i = 0; (flt = filterArray[i]); i++) {
        oflt = {
            "id": flt[0],
            "logic": {
                "NOT": flt[2],
                // convert '0' -> false
                "OR": flt[3] == false,
                "RANGE": flt[3]
            },
            "value": flt[5]
        };
        flts.push(oflt);
    }

    return flts;
}

function filterLoadResource() {
    $j.addLang("lang/", "filter");

    var reg = {
        "en":     "",
        "GB2312": "zh-CN",
        "x-sjis": "ja",
        "euc-kr": "ko",
        "sp":     "es",
        "big5":   "zh-TW",
        "fr":     "fr",
        "po":     "pt"
    }[window.filterLang];
    // load date picker regional
    if (reg) {
        $j.addScript("/js/ui.datepicker-" + reg + ".js");
        $j.datepicker.setDefaults($j.datepicker.regional[reg]);
    }
    if (!$j.fn.filterConsole) {
        $j.addScript('/js/jquery.filterConsole.js');
    }
}

// only used by apache modules, jquery.qlist.js has its own version of this function
// DEPRECATED: use jquery.qlist's filter option
function filterSetup(tableId, columnsArray, cookieName, config)
{
    filterLoadResource();

    // set filter column
    var filterParam = getParams({filter:null}).filter;
    var filterString = filterParam || getCookie(cookieName);
    $j(tableId).filterConsole($j.extend({
        "columns": fieldColumnParse(columnsArray),
        "filters": fieldFilterParse(deserializeArray(filterString ? filterString : "")),
        "expanded": filterExpaned,
        "action": doOK
    }, config));
}

//@ sourceURL=module_js/filter.js
