/* Provide callback function for displaying archive panel for DetailsWindow */

if (typeof (FOSGUI) === 'undefined') {
    FOSGUI = {};
}

if (typeof (FOSGUI.LogArchivePanel) === 'undefined') {
    FOSGUI.LogArchivePanel = {};
}

// namespace
FOSGUI.LogArchivePanel = (function ($) {

function archive_cb(row) {
    var re = /logs\/(\S+)\//;
    var match = window.location.pathname.match(re);
    if (match && row) {
        switch (match[1]) {
        case 'ips': case 'app': return ips_callback(row);
        case 'av': return av_callback(row);
        case 'traffic': case 'local_traffic':
        case 'log_event': case 'multicast_traffic':
        case 'sniffer_traffic':
            if ('_pcap_appid' in row || '_pcap_attackid' in row)
                return ips_callback(row);
            if ('dlparchive' in row)
                return dlp_callback(row, true);
            return traffic_callback(row);
        case 'dlp': return dlp_callback(row, false);
        }
    }
    return $j.getInfo('no_archive_data');
}

function av_callback(row) {
    var msg = row._is_archived ?
        $j.getInfo('loading') : $j.getInfo('no_archive_data');
    var html = '<div id="av-placeholder">' + msg + '</div>';
    if (row._is_archived) {
        $j.get('/p/logs/av_archive/' + row.checksum + '/' + row.filename + '/',
               function(data) {
                   $j('#av-placeholder').html(data);
               });
    }
    return html;
}
function render_data_table(row, keys) {
    var html = '<table cellspacing="1" cellpadding="0" ' +
        'class="list log_details">';
    for (var i = 0; i < keys.length; ++i) {
        var key = keys[i];
        if (!(key in row))
            continue;
        var value;
        if (key in formatter) {
            value = formatter[key](key, row);
        } else {
            value = row[key];
        }
        html += '<tr class="' + (i % 2 ? 'odd' : '') +'">';
        html += '<td class="label"><b>' + $j.getInfo(key) + '</b></td>';
        html += '<td class="value">' + value + '</td>';
        html += '</tr>';
    }
    html += '</table>';
    return html;
}

//Suffix is intended to be a digit, and is therefore not translated.
function render_ref(url, title, suffix) {
    var html = '<a href="#" onclick="window.location=\'' + url + '\'">';
    suffix = (typeof suffix === 'number') ? suffix : '';
    html += '<span class="tool_sprite tool_download"> ';
    html += $j.getInfo(title) + ' ' + suffix + '</span></a>';
    return html;
}

function dlp_callback(row, show_pkt_capture) {
    var keys = ['timestamp', 'srcip', 'dstip', 'sentbyte', 'rcvdbyte',
                'service'];
    var html = '<div>' + render_data_table(row, keys), url, i;
    if (row._is_archived) {
        if (show_pkt_capture)
            html += render_dl_cap_file(row);
        var archive_sn = row.max_archive_sn;
        var archive_name = row.archive_name + ":" + archive_sn;
        if (row.is_email) {
            url = qlist_url_append_arg(
                '/log/display_email', 'device', device_id);
            url = qlist_url_append_arg(url, 'logid', archive_name);
            url = qlist_url_append_arg(url, 'type', row.service_type);
            url = qlist_url_append_arg(url, 'roll', row.roll);
            html += '<a href="#" onclick="popup_resizable(\''
                + url + '\', \'email_dialog\', 610, 480);">';
            html += '<span class="tool_sprite tool_view"> ';
            html += $j.getInfo('view_email') + '</span></a>';
        } else {
            url = qlist_url_append_arg(
                '/log/display_content', 'device', device_id);
            url = qlist_url_append_arg(url, 'logid', archive_name);
            url = qlist_url_append_arg(url, 'type', row.service_type);
            url = qlist_url_append_arg(url, 'roll', row.roll);
            var filename = row.filename;
            var suffix =  archive_sn > 0 ? archive_sn : '';
            if (!filename) {
                var timestamp = String(row.timestamp).replace(/[\s|:]+/g, '_');
                filename = "dlp_archive-" + timestamp + (archive_sn > 0 ? "-" + suffix : "");
            }
            url = qlist_url_append_arg(url, 'filename', filename);
            html += render_ref(url, 'download_dlp_archive', suffix);
        }
    }
    html += '</div>';
    return html;
}

function render_dl_cap_file(row) {
    if (!row.sessionid || !row.packet_dst || !row.packet_src)
        return '';

    var url = qlist_url_append_arg(
        '/downloadfile/' + row.sessionid + '.pcap', 'msg', '31');
    url = qlist_url_append_arg(url, 'sid', row.sessionid);
    url = qlist_url_append_arg(url, 'dst', row.packet_dst);
    url = qlist_url_append_arg(url, 'src', row.packet_src);
    return render_ref(url, 'download_capture_file');
}

function traffic_callback(row) {
    var keys = ['timestamp', 'srcip', 'dstip', 'sentbyte', 'rcvdbyte'];
    var html = '<div>' + render_data_table(row, keys);
    if (row._is_archived) {
        html += render_dl_cap_file(row);
    }
    html += '</div>';
    return html;
}

function ips_callback(row) {
    var keys = ['timestamp', 'attack', 'pri', 'user', 'proto', 'count'];
    var html = '<div class="ui-layout-center flex-row-container"><div>' + render_data_table(row, keys);
    if (row._is_archived) {
        var url = qlist_url_append_arg(
            '/downloadfile/' + row._pcap_id + '.pcap', 'msg', '24');
        // FortiAnalyzer has no _pcap_category in row
        var _pcap_category = row._pcap_category || 0;
        url = qlist_url_append_arg(url, 'pcap_no', row.roll);
        url = qlist_url_append_arg(url, 'pcap_id', row._pcap_id);
        url = qlist_url_append_arg(url, 'pcap_category', _pcap_category);
        url = qlist_url_append_arg(url, 'device', device_id);
        html += render_ref(url, 'download_capture_file');
        html += '</div>';

        url = '/p/logs/pkt_frameset/' + row.roll + '/' + row._pcap_id + '/' + _pcap_category + '/';
        html += '<iframe class="ui-layout-east" src="' + url  +'"/>';
    } else {
        html += '</div>';
    }
    return html;
}


return {
        archive_cb: function (row) {
            return archive_cb(row);
        }
    }
})(jQuery);
