/*global byod_common,DetailsWindow,fgd_common, $j, fweb, FOSGUI, byod_common*/
/* viewer.html *//*global device_id,resolve_apps, log_ng */
/* Util.js     *//*global getQueryValue,setQueryValue, escapeHTML , getParams*/
/* filter.js   *//*global FIELD_TYPE, FIELD_TYPE_STRINGS */
/* log_formatter.js   *//* FOSGUI.LogFormatter  getFormatter(), format_fn_to */
/* log_archive.js   *//* FOSGUI.LogArchivePanel.archive_cb */

var qlist_prefix = 'qlist_log_'+log_ng.log_type;
var now = new Date();
var dlg = null;
var param_filter = getQueryValue(window.location.search, 'filter');
var is_embedded = getQueryValue(window.location.search, 'is_embedded');
var is_fortiview =  !!parseFloat(getQueryValue(window.location.search, 'fortiview'));
//'col,-col2' <= col is default, remove col2 from default columns
var param_default_cols = getQueryValue(window.location.search,
    'default_cols') || '';
var qlist_columns_url = '/log/display/column?log_type='+log_ng.log_type;

qlist_prefix += param_default_cols.replace(/,/, '_');

// Forticloud device id
var LOG_PRESENT_DEVICE_FDS = 4;

/**
 * @param  {[Number]} device_id          The number that represents the device
 * @param  {[Array]} columns_collection  It is an array that contains objects
 *                                       with all available columns and default
 *                                       columns.
 *                                       ex: [{
 *                                           'columns': [{
 *                                               "fixed": true,
 *                                               "lang_key": "#",
 *                                               "selector": "#"
 *                                           },
 *                                           ...],
 *                                           'default_columns': Array
 *                                       },
 *                                       ...]
 * @return {[Array]}                     The list of columns which have the
 *                                       filter disabled
 */
function get_filter_disable_columns(device_id, columns) {
    'use strict';
    /* jshint bitwise: false */
    //Should reflect LOG_FIELD_FCLD_FILTER in migbase/include/log_def.h
    var LOG_FIELD_FCLD_FILTER = (1 << 2);
    var filter_disable_columns = [
            '#',
            '_is_archived',
            'app_details',
            'threat',
            'sent_rcvd',
            'clouddetails',
	    'type',
	    'device_id',
	    'timezone',
	    'detail',
	    'http_request_time',
	    'http_response_time',
	    'http_request_bytes',
	    'http_response_bytes',
//	    'http_retcode',
	    'monitor_status'
        ];

    if(log_ng.log_type == '3')
    {
	    filter_disable_columns.push('proto');
//	    filter_disable_columns.push('service');
    }

    if (device_id === LOG_PRESENT_DEVICE_FDS) {
        columns = $j.grep(columns, function(col) {
            return col.gui_disp & LOG_FIELD_FCLD_FILTER > 0;
        });
        return filter_disable_columns.concat($j.map(columns, function(col) {
            return col.selector;
        }));
    }

    if (log_ng.log_type === 'av') {
        filter_disable_columns.push('av_details');
    }

    return filter_disable_columns;
}

var formatter = FOSGUI.LogFormatter.getFormatter();
var archive_cb = FOSGUI.LogArchivePanel.archive_cb;

function show_threat_details(event) {
    'use strict';
    var parent = $j(event.target);
    var tab_id = parent.data('tab');
    if (tab_id) {
        if (parent.data('utmref') !==
            $j('a[href$="#' + tab_id + '"]').data('utmref')) {
            parent.closest('td').click();
        }
        $j('a[href$="#' + tab_id + '"]').click();
    }
    return false;
}

function new_content_cb(content, is_embedded, is_fortiview, is_forward_threat_detail) {
    'use strict';
    //These 'fake' columns should never appear in the qlist or details window, but must
    //still be passed to the details window (ie. not be filtered by get_filtered_content())
    //because the formatter functions make use of them.
    var pseudocolumns = [
        'roll', 'dstcountry_code', 'byod_device', 'byod_name', /^_/,
        'packet_src', 'packet_dst', 'archive_name', 'max_archive_sn',
        'service_type'
    ];
    now = new Date(Date.parse(content.now));

    if (!is_embedded) {
        DetailsWindow.initialize({
            containerSelector: 'body',
            rowData: content.source,
            mainPanelSelector: '#main_window',
            contentBodySelector: '#contentHead table.qlist > tbody:first',
            formatCallbacks: formatter,
            detailsLocation: 'east',
            archiveData: content.source,
            getArchiveCallback: content.is_archive_enabled ? archive_cb : null,
            isShowThreatDetails:  content.is_utm_detail_enabled &&
                    (!content.is_fortiview || content.is_all_session),
            hiddenColumns: pseudocolumns,
            selectionChangedCallback: details_window_selection_changed,
            langOverride: {
                threat: $j.getInfo('log_utm_events')
            }		
        });
    } else {
        if (is_forward_threat_detail) {
            DetailsWindow.initialize({
                containerSelector: 'body',
                rowData: content.source,
                mainPanelSelector: '#main_window',
                contentBodySelector: '#contentHead table.qlist > tbody:first',
                formatCallbacks: formatter,
                detailsLocation: 'south',
                archiveData: content.source,
                getArchiveCallback: content.is_archive_enabled ? archive_cb : null,
                isShowThreatDetails: content.is_utm_detail_enabled &&
                    (!content.is_fortiview || content.is_all_session),
                hiddenColumns: pseudocolumns,
                selectionChangedCallback: details_window_selection_changed,
                langOverride: {
                    threat: $j.getInfo('log_utm_events')
                },
                dataOnly: true

            });
        } else {
            $j('.qlist_hdrbar').hide();
        }
    }

    if (is_forward_threat_detail && !$j.support.flexbox) {
        var parent_jQuery = parent.$j;
        var parent_height =
            parent_jQuery('#logview-details').innerHeight();
        var new_height = parent_height - 45;
        parent_jQuery('.threat_detail_frame')
            .height(new_height);
        $j('#main_window').height(new_height);
        $j('#contentHead')
            .css('height', new_height)
            .find('.ql-body-container').css('height', new_height - 27);
    }

    // TODO: Check if it is needed
    // $j("#contentHead")
    //     .css("height", $j("#main_window").height());

    if (is_embedded && dlg) {
        dlg.refresh();
    }
    if (is_fortiview && is_embedded) {
        $j('#main_window').addClass('fortiview-embedded');
    }
}

function details_window_selection_changed() {
    'use strict';
    //Re-apply the tooltips when details pane regenerated
    byod_common.setup_device_tooltips();
    //fgd_common.setup_tooltips('span.tooltip', 'fromclass', (resolve_apps === 'enable'));
}

var last_session_id = 0;
// Warning, can be called multiple times
function log_onload(filter) {
    'use strict';
    var arg_filter = filter;
    var json_path = '/log/display/json';
    json_path = setQueryValue(json_path, 'log_type', log_ng.log_type);
    json_path = setQueryValue(json_path, 'log', log_ng.logfile);
    json_path = setQueryValue(json_path, 'offset', log_ng.offset);

    filter = filter ? JSON.stringify(filter) : param_filter;

    json_path = setQueryValue(json_path, 'filter', filter);
    var log_device = getQueryValue(window.location.search, 'log_device');
    var is_forward_threat_detail = getQueryValue(window.location.href, 'forward_threat_detail');
    var is_all_session = is_fortiview &&
        (parent.location.hash === '#/fortiview/session');
    var page_rows = getQueryValue(window.location.href, 'rows');
    if (is_forward_threat_detail && page_rows) {
        json_path = setQueryValue(json_path, 'rows', page_rows);
    }
    if (is_fortiview) {
        json_path = setQueryValue(json_path, 'log_device', log_device);
    }
    function single_arg_filter(arg) { return arg }
    log_ng.ready = $j.when($j.getJSON(json_path).then(single_arg_filter), log_ng.columns).then(
    function(content, column) {
        var $contentHead = $j('#contentHead').empty();
        if (content.status === 'error') {
            $j.alert($j.getInfo(content.error_code));
        }
        content.is_fortiview = is_fortiview;
        content.is_all_session = is_all_session;

        $j(window)
        /*
            .off('.log_onload_handlers')
            .on('beforeunload.log_onload_handlers', function() {
                // cancel search before leave page
                if (content.session_id) {
                    $j.ajax({
                        'url': '/p/logs/search/abort/' + content.session_id + '/',
                        'async': false
                    });
                }
            })*/
        .off('message.qlistsource')
        .on('message.qlistsource', function(event) {
            //Listen for events posted from FortiView
            //jquery events don't transfer MessageEvent properties well.
            event = event.originalEvent || event;
            var data = event.data;
            if (event.origin !== window.location.origin || !data.get) {
                return;
            }
            if (data.get === 'qlist.source' && data.id) {
                event.source.postMessage({put: data.get, value: content.source, id: data.id},
                                         window.location.origin);
            }
        });

        function search_completed() {
            return content.completed >= 100;
        }

        now = new Date(Date.parse(content.now));

        function is_col(col_name) {
            return function(col) {
                return col.selector === col_name;
            };
        }
        // add filtered columns to default columns
        var filter_str = getParams({'filter': ''}).filter;
        if (filter_str) {
            var filter_obj = JSON.parse(filter_str);
            for (var i = 0, len = filter_obj.length; i < len; ++i) {
                var col = filter_obj[i].id;
                if (column.default_columns.indexOf(col) === -1 &&
                        column.columns.some(is_col(col))) {
                    column.default_columns.push(col);
                }
            }
        }
        function replace(expr, new_val) {
            return function(val) { return val.replace(expr, new_val) };
        }
        function in_arr(arr) {
            return function(val) { return arr.indexOf(val) !== -1 };
        }
        function not(fn) { return function(val) { return !fn(val) } }
        var add_cols = [];
        if (param_default_cols) {
            var remove_ex = /^-/;
            var remove_test = remove_ex.test.bind(remove_ex);
            var cols = param_default_cols.split(',');
            add_cols = cols
                .filter(not(remove_test));
            var rm_cols = cols.filter(remove_test)
                .map(replace(remove_ex, ''));
            column.default_columns = column.default_columns
                .filter(not(in_arr(rm_cols)))
                .concat(add_cols.filter(
                    not(in_arr(column.default_columns))
                ));
        }
        function col_order(cols, prop) {
            return function sort(a, b) {
                //sort by position in cols array, if a column isn't in the array
                //then it goes at the end in the original order.
                return index(prop ? a[prop] : a) - index(prop ? b[prop] : b);
            };
            function index(value) {
                //if it's not found, shuffle it toward the back;
                value = cols.indexOf(value);
                return value > -1 ? value : Number.MAX_VALUE;
            }
        }
        //sort by language translated order.
        function lang_order(a, b) {
            return $j.sortCompareText(
                $j.getInfo(a.lang_key),
                $j.getInfo(b.lang_key)
            );
        }
        last_session_id = content.session_id;
        var qlist_settings = {
            source: content.source,
            columns: column.columns
                .sort(lang_order)
                .sort(col_order(add_cols, 'selector')),
            //default_columns: column.default_columns.sort(col_order(add_cols)),
	    default_columns: column.default_columns,
            checkboxes: {
                enabled: false,
                hide_disabled: false
            },
            options: {
                hide_default_buttons: true,
                disable_context_menu: true,
                resizable_columns:false,
                fixed_footer: true,
                hide_menu: true,
                resize_to_parent: false,
                css_layout: true
            },
            column_filters: {
                enabled: false,
                value: JSON.parse(filter),
                highlight: { enabled: !is_embedded && !is_fortiview},
                log_type: content.log_type,
                // disable default filtering
                filter_fn: null,
                server_side_reload: function() {
                    log_onload(arg_filter);
                }
            },
            row_attr: [
                {selector: '#', name: 'mkey'},
                {selector: 'fpos', name: 'fpos'},
                {selector: 'logfile', name: 'logfile'},
                {selector: 'length', name: 'length'}
            ],
            format_fn: {
                // set default to escape all outputs prevent XSS Injection
                '*': function(td, col, entry) {
                    return escapeHTML(entry[col.selector]);
                }
            },
            paging: {
                enabled: !(is_forward_threat_detail && page_rows),
                server_side: true,
                total_lines: content.total_lines,
                completed: search_completed,
                last_page_button: log_ng.device_id !== LOG_PRESENT_DEVICE_FDS,
                fetch: function(page_num, cb) {
                    if (content.session_id !== last_session_id) {
                        return;
                    }
                    var path = json_path;
                    path = setQueryValue(path, 'session_id', content.session_id);
                    path = setQueryValue(path, 'page', page_num);
                    path = setQueryValue(path, 'offset', log_ng.offset);
                    if (page_num !== content.page_num) {
                        content.page_num = page_num;
                        content.source.length = 0;
                    } else {
                        path = setQueryValue(path, 'fetched', content.source.length);
                    }
                    /* this for filter change page info*/
                    var raw_path = decodeURI(json_path);
                    var filter_start = raw_path.indexOf('logic"%3A{"is');
                    var filter_end = raw_path.indexOf('id"%3A"');
                    var default_file = ((raw_path.indexOf('alog.log')!=-1) || (raw_path.indexOf('alog.log') !=-1) || (raw_path.indexOf('alog.log') != -1))?true:false;
		            var is_filter = (default_file && raw_path.substring(filter_start,filter_end).indexOf('rel_time') != -1 )?true:false;
                    log_ng.showLoading();
                    $j.getJSON(path, function(data) {
                        log_ng.hideLoading();
                        content.completed = data.completed;
                        //The call order is critical, because cb updates DOM
                        cb(data);
                        $j.merge(content.source, data.source);
                        content.total_lines = data.total_lines;                        
                        if (!$j('tr.selected', '#contentHead').length) {
                            new_content_cb(content, is_embedded, is_fortiview,
                                is_forward_threat_detail);
                        }
                        //$j('#contentHead').qlist('refresh');
                        $j(".ql-body-table").resize(function() {
                                $j('#contentHead').qlist('refresh');
                        })
                        if(is_filter) changePageText(data.source.length);
                        log_ng.offset = data.offset;
                        
                    });
                }
            },
            prefix: qlist_prefix,
            callbacks: {
                load: function() {
                    details_window_selection_changed();
                }
            },
	    row_gen: function(rowIndex, row_data)
	    {
		    if(log_ng.log_type == 1)
		    {
			    var pri = row_data['pri'] ? row_data['pri'] : 'information';
			    var c = 'log_' + pri;
			    this.addClass(c);
		    }
		    else if(log_ng.log_type == 3)
		    {
			    var action = row_data['action'].toLowerCase();
			    var monitor = row_data['monitor_status'] ? row_data['monitor_status'] : 'Disabled';
			    var	c = '';
			    if(monitor == 'Enabled')
				    c = 'odd';
			    else
			    {
				    if(action == 'alert')
					    c = 'odd';
				    else
					    c = 'log_deny';
			    }

			    this.addClass(c);
		    }
	    }
        };

        if (getParams({fortiview: 0}).fortiview) {
            delete qlist_settings.menu_items;
            qlist_settings.options.hide_menu = true;
        }

        // delegate the format function to the appropriate formatter function
        for (var x in formatter) {
            qlist_settings.format_fn[x] = FOSGUI.LogFormatter.format_fn_to;
        }

        // Fix bug 0460600
        if ($contentHead.data('headContextMenu')) {
                $contentHead.data('headContextMenu').destroy();
        }
        
        var result = $contentHead
            .removeData()
            .qlist(qlist_settings);
        $j.internationalizeLanguageEntries();

        new_content_cb(content, is_embedded, is_fortiview, is_forward_threat_detail);
        $j('#loading').hide();

        var raw_path = decodeURI(json_path);
        var filter_start = raw_path.indexOf('logic"%3A{"is');
        var filter_end = raw_path.indexOf('id"%3A"');
        var default_file = ((raw_path.indexOf('alog.log')!=-1) || (raw_path.indexOf('alog.log') !=-1) || (raw_path.indexOf('alog.log') != -1))?true:false;
        var is_filter = (default_file && raw_path.substring(filter_start,filter_end).indexOf('rel_time') != -1 )?true:false;
        if(is_filter) changePageText(content.source.length);

        log_ng.offset = content.offset;

	 setInactiveCountDown(timeout_in_sec);
	 return $j.when(content.source, result);

    });

    if (!is_embedded) {
        $j(document)
            .off('.log_onload_handlers')
            .on('click.log_onload_handlers', 'a.threat_details', show_threat_details)
            .on('keydown.log_onload_handlers', DetailsWindow.keypress)
            .on('click.log_onload_handlers', 'tr.qlist_row', DetailsWindow.click);
    } else if (is_forward_threat_detail) {
        // TO highlight/unhighlight row, also bind the click event
        // click event: highlight/ un-hightlight row
        // dblclick: highlight/ un-hightlight row, show detail dialog
        $j(document)
            .off('.log_onload_handlers')
            .on('click.log_onload_handlers', 'tr.qlist_row', DetailsWindow.click)
            .on('dblclick.log_onload_handlers', 'tr.qlist_row', DetailsWindow.dblclick);
    }
    log_ng.onload = log_onload;
}

log_ng.showLoading = function() {
    'use strict';
    $j('#loading').css('display', '');
    $j('#contentHead').children().hide();
};


log_ng.hideLoading = function() {
    'use strict';
    $j('#loading').hide();
    $j('#contentHead').children().show();
};

log_ng.columns = $j.getJSON(qlist_columns_url).then(function(column) {
    'use strict';
    column.columns.forEach(function(col) {
        var returntrue = function() { return true; };
        // manually override the field type of some columns
        if (col.novalidate) {
            if (col.filter == null) { col.filter = {}; }
            col.filter.validate = returntrue;
        }

        // TODO: some of these overrides should be done in log_filter.pyx
        if (col.selector === 'itime') {
            col.fld_type = FIELD_TYPE.TIME;
        } else if (col.selector === 'idate') {
            col.fld_type = FIELD_TYPE.DATE;
        } else if (col.selector === 'timestamp') {
            col.fld_type = FIELD_TYPE.DATE_TIME;
        } else if (col.selector === 'rel_time') {
            col.fld_type = FIELD_TYPE.DATE_TIME;
        }
        if ('fld_type' in col) {
            col.type = FIELD_TYPE_STRINGS[col.fld_type];
        }
    });
    return column;
});
log_ng.get_filter_disable_columns = get_filter_disable_columns;

var page_ready = $j.Deferred(),
    search_ready = is_embedded || is_fortiview ||
        fweb.util.functional.castToJQueryPromise(log_ng.search_ready);
$j(document).ready(page_ready.resolve.bind(page_ready));

//wrap onload function because otherwise the filter gets set incorrectly
$j.when(search_ready, page_ready)
    .then(function(filter) {
        'use strict';
        log_onload(Array.isArray(filter) ? filter : undefined);
    });

function changePageText(num)
{
	$j(".total_lines").text(num);
    $j(".page_last").removeClass('list_action');
    $j(".page_last").addClass('tool_last0');
    $j(".page_current").attr('disabled','true');
    $j(".page_current").next().html ('');
    $j(".page_current").next().next().attr('style','display:none');
    $j(".total_lines").parent().parent().attr('style','display:none');
}
