/*
  logdisklist.js - misc JS code for logdisklist.c
  init Mar 2011 by Jianjiang Yan
  GUI redesign project
  Copyright Fortinet Inc
*/
function logdisklist_view_elem(q, elem)
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;
    var form = document.logdisklist;

    var logname = aElems[0].getAttribute("name");
    var path = aElems[0].getAttribute("path");
    window.location.href = "/log/display/disk?log="+logname+"&device="+form.device.value+"&sn="+form.sn.value;
}
function logdisklist_down_elem(q, elem)
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;
    var form = document.logdisklist;

    var logname = aElems[0].getAttribute("name");
    var path = aElems[0].getAttribute("path");
    form.action = "/log/disk/download";
    form.name.value = logname;
    form.submit();
//    window.location.href = "/log/disk/download?msg="+form.msg.value+"&name="+logname+"&url="+form.log.value+"&sn="+form.sn.value;
}
function logdisklist_del_elem(q, elem)
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length < 1) return;
    var form = document.logdisklist;

    if (!confirm(qed_strtbl.del_confirm)) {
        return;
    }
    form.action = "/log/disk/del";
    for(var i=0;i<aElems.length;i++){
        form.name.value += "&" + aElems[i].getAttribute("name");
    }

    form.submit();
    //window.location.href = url + "&log=" + form.log.value + "&sn=" + form.sn.value;
}

function logdisklist_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();	

    if (aElems.length == 1)
    {
        qmenu_enable_button($j("#mi_view"), true, q);
        qmenu_enable_button($j("#mi_down"), true, q);
        //qmenu_enable_button($j("#mi_del"), true, q);
    }else{
	qmenu_enable_button($j("#mi_view"), false, q);
	qmenu_enable_button($j("#mi_down"), false, q);
	//qmenu_enable_button($j("#mi_del"), false, q);
    }

    if(aElems.length >= 1){
        if(fips_status == true){
		qmenu_enable_button($j("#mi_del"), false, q);
	}else{
		qmenu_enable_button($j("#mi_del"), true, q);
        }
    }
}

// logdisklist_menu - Override the default menubar to add button "run" "rename".
function logdisklist_menu(aItems)
{
        var mNew = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
                   text:logdisklist_strtbl.view, click:{fn:logdisklist_view_elem} });
        aItems.push(mNew);

        var mNew = Page.createMenuItem({id:"mi_down", spriteClass:"tool_down", ctxt:true,
                   text:logdisklist_strtbl.down, click:{fn:logdisklist_down_elem} });
        aItems.push(mNew);
    if (is_rw_admin) {
        var mRename = Page.createMenuItem({id:"mi_del", spriteClass:"tool_clear", ctxt:true,
                   text:logdisklist_strtbl.del, click:{fn:logdisklist_del_elem} });
        aItems.push(mRename);
    }
}

// logdisklist_onload - onload handler for the clientbrowsereport list page.
function logdisklist_onload()
{
    // Customize the qlist definition.
    qlist_obj.create_new = false;
    qlist_obj.create_edit = false;
    qlist_obj.create_del = false;
    qlist_obj.customize_menu_fn = logdisklist_menu;
    qlist_obj.handle_selection_change_fn = logdisklist_handle_selection_change;

//    $j("tr", "#qlist").live("click", logdisklist_view_elem);

    $j('#ftrtc').append($j('#paging_row'));
    $j('#paging_row').css('visibility', 'visible');

    qlist_setup("qlist", null,null,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", logdisklist_onload);

