/******************************
 logdisplay.js - log viewer support code
 Init by A. Krywaniuk, Apr 2008 (extracted from logdisplay.c)
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// doAction - perform an action in the header bar (e.g. page up/down, toggle format)
// that results in the log frame being refreshed.
/*
** actionNumber 0:search prev 1: search next
*/
function doAction(actionNumber)
{
    var form = document.forms[0];
    var startline_val = parseInt(form.startline.value);
    var viewlines_val = parseInt(form.viewlines.value);
    var is_detailed = 0;
    form.method = "POST";

    var del = "";

    if(this.id == "mi_refresh")
    {
    	actionNumber = 4;
    }else if(this.id == "mi_raw" || this.id == "mi_formatted" )
    {
    	actionNumber = 2;
    }

    switch (actionNumber)
    {
    case 0 : // page up
        var new_startline = startline_val - 300;
        if (new_startline < 1)
            new_startline = 1;
        form.startline.value = new_startline;
		form.is_prev.value = 1;//for page 11 jump to 10
        break;

    case 1 : // page down
        var new_startline = startline_val + 300;
        //if (new_startline <= parseInt(form.total.value))
        form.startline.value = new_startline;
		form.is_prev.value = 0;
        break;

    case 2 : // toggle raw-formatted
        is_detailed = 1-parseInt(form.is_detailed.value);
	form.is_detailed.value = is_detailed;
	//if(is_detailed)
		//parent.document.getElementsByTagName("frameset")[0].rows = "*,1";
	//else
		//parent.document.getElementsByTagName("frameset")[0].rows = "*,*";
        break;

    case 3 :
        // TODO: is it really smart to put the '?' outside of the translated string?
        if (!confirm(logdisplay_texts.del_confirm + "?"))
            return;

        var aDeletions = form.del;
        var len = aDeletions.length;

        var pre=0;
        for (var i=1; i<len; i++)
        {
            if (aDeletions[i].checked)
            {
                if (!pre)
                    del='&del=' + aDeletions[i].value;
                else
                    del+=','+ (i-pre);
                    pre=i;
            }
        }
        break;
    case 4 :
        form.startline.value = 1;
        if(form.currentPage)
        {
            form.currentPage.value = 1;
        }
        if(form.is_prev)
        {
        	form.is_prev.value = 0;
        }        
        break;
    }
    form.log.value = unescape(form.log.value);
    form.submit();
}


// check_startline - check that the line number is within range.
function check_startline(obj)
{
    var line = parseInt(obj.value);
    var total_lines = parseInt(document.forms[0].total.value);
    if ((line <= 0) || (line > total_lines))
    {
        alert(logdisplay_texts.startline_err);
        obj.value = '1';
    }
}


// chg_selection - change the selected HA cluster and refresh the page.
function chg_selection()
{
    var target_wnd = window;
    var oForm = document.forms[0]
    var log_type = oForm.log.value;

    // NOTE: the original version of this function would actually rebuild the button
    // list in the subnav frame. We don't do that anymore, but we need to preserve
    // some of the functionality.

    // Update the "log=..." field in the URL.
    var url = target_wnd.location.href;
    url = update_url_component(url, "log", log_type);

    // If in HA mode then also specify the device id (for local logs only).
    if (oForm.ha_cluster)
    {
        var cluster = oForm.ha_cluster.value;
        url = update_url_component(url, "sn", cluster);
    }
    url = update_url_component(url, "device", oForm.device.value);

    target_wnd.location = url;

    // TODO: maybe store the selected log type somewhere (navbar frame? session cookie?) as well
    // and use it as the default value when making the request.
}
/*
// Column Settings
function setColumns()
{
debugger;
    var csv = implodeField(document.forms[0].chosen, ',', 0);

    parent.window.document.forms[0].columns_csv.value = csv;
    setCookie("log/display/columns" + logdisplay_opts.type, csv);
    parent.window.doAction();
    parent.window.wij_end_modal_dialog();
}
*/

function flt2LogFilter(flt)
{
    var col;
    for (var i = 0; (col = filter_settings.logColumns[i]); i++)
        if (col[0] == flt.id) break;

    return new LogFilter(
            flt.id,
            col[2],
            flt.logic.RANGE ? 1 : 0,
            flt.logic.NOT ? 1 : 0,
            flt.logic.RANGE ? flt.value[0] : "",
            flt.logic.RANGE ? flt.value[1] : "",
            flt.value);
}

function logfilterOK(panel)
{
    var logType = logdisplay_opts.type;
    var filter;
    var value_array;

    var filterCookieString = getCookie(filterCookieName);
    logFilterCookieArray = deserializeArray(filterCookieString ? filterCookieString : "");
    logFilterCookieArray[logType] = [];

    var err = 0;

    $j(panel).filterSection(
        function (flt) {
            if (!validate(flt)) {
                err = 1;
                return false;
            }
            if (flt.value && flt.value.join("").length) {
                logFilterCookieArray[logType] = setDisplayFilter(logFilterCookieArray[logType], flt2LogFilter(flt));
            }
        });

    if (err) return false;

    setCookie(filterCookieName, serializeArray(logFilterCookieArray));
    var form = document.forms[0];
    //var url = setQueryValue(location.href, "startline");
    //window.location = setQueryValue(url, "expanded", $j("input[name=expanded]", panel).val());
    /* now expanded no use*/
    form.method = "POST";              
    form.startline.value = 1;
    form.log.value = unescape(form.log.value);
    form.submit();

    return false;
}

function LogFilter(fieldName, filterType, contains, negate, fromValue, toValue, valueList)
{
    this.fieldName = fieldName;
    this.filterType = filterType;
    this.contains = contains;
    this.negate = negate;
    this.fromValue = fromValue;
    this.toValue = toValue;
    this.valueList = valueList;

    this.toArray = function toArray() {
        var filterArray = new Array(this.fieldName, this.contains, this.negate, this.fromValue, this.toValue, this.valueList);
        return filterArray;
    }
}

function logdisplay_column_setting()
{
    var form = document.forms[0];
    var url = "/log/display";

    url = qlist_url_append_arg(url, "log", form.log.value);
    url = qlist_url_append_arg(url, "frame", "columns");
    url = qlist_url_append_arg(url, "columns_csv", form.columns_csv.value);
    //url = qlist_url_append_arg(url, "content_type", form.content_type.value);
    url = qlist_url_append_arg(url, "device", form.device.value);

    /* hidden detail frame when open modal*/
    //parent.document.getElementsByTagName("frameset")[0].rows = "*";
    wij_display_modal_dlg(url, { "width": 510, "height": 335 });
}

function logdisplay_filter_setting()
{
    $j("#qlist_hdrrow").filterPopout();
}
/*
    function selectRow(row) {
        if (typeof row == "undefined") {
            return;
        }

        if (typeof(selectedRowEntry) != "undefined") {
            $j(selectedRowEntry).toggleClass("log_entry_selected", false);
            selectedRowEntry = null;
            selectedRowEntryIndex = 0;
        }

        // set selected entry
        selectedRowEntry = row;
        //selectedRowEntryIndex = row.rowIndex - first_row.rowIndex;
        $j(selectedRowEntry).addClass("log_entry_selected");
    }
    function showRowDetailsClick(e) {
        var target = e.target.parentNode;

        while (target) {
            if (target.tagName == "TR") {
		if(target.getAttribute("url") != "")selectRow(target);
                logdisplay_viewdetail(target, e);
                break;
            }

            if (target.parentNode) {
                target = target.parentNode;
            } else {
                return false;
            }
        }

        return true;
    }
*/
//function logdisplay_viewdetail(target, e)
function logdisplay_viewdetail(pos)
{/*
    if(target.getAttribute("url") != "" && target.getAttribute("url") != null)
	parent.log_display_detail.location.href = target.getAttribute("url");

//    if (aElems.length != 1) return;

*/
    if (pos == "hide") {
        DetailsWindow.hide();
        return;
    }
    
    if (pos == "pushdown" || pos == "pushside") {
        DetailsWindow.move(pos == "pushdown" ? "east" : "south");
    }

    DetailsWindow.show();

}

function logdisplay_merge()
{
    var form = document.forms[0];
    form.aggregate.value = 0;
    var url = "/log/display";

    url = qlist_url_append_arg(url, "log", form.log.value);
    url = qlist_url_append_arg(url, "frame", "merge");
    url = qlist_url_append_arg(url, "merge_filter", form.merge_filter.value);

    /* hidden detail frame when open modal*/
    //parent.document.getElementsByTagName("frameset")[0].rows = "*";
    wij_display_modal_dlg(url, { "width": 510, "height": 326 });
}

function logdisplay_aggregate(days)
{
    var form = document.logdisplay;
    form.aggregate.value = days;
    form.startline.value = 1;
    form.submit();
}

/*
function logdisplay_hidesub(hide_sub)
{
    var form = document.logdisplay;
    form.hide_sub.value = hide_sub;
    form.startline.value = 1;
    form.submit();
}
*/

function logdisplay_common()
{
	var form = document.logdisplay;
	form.aggregate.value = 0;

	parent.log.location = "/log/display?log=" + form.log.value + "&device=" + form.device.value + "&sn=" + form.sn.value + "&frame=log";
}

function logdisplay_filter(log,field_name)
{
    var url = "/log/display";

    url = qlist_url_append_arg(url, "log", log);
    url = qlist_url_append_arg(url, "frame", "filter");
    url = qlist_url_append_arg(url, "field_name", field_name);

    /* hidden detail frame when open modal*/
    //parent.document.getElementsByTagName("frameset")[0].rows = "*";
    wij_display_modal_dlg(url, { "width": 510, "height": 326 });
}

function logdisplay_search()
{
    var form = document.forms[0];
    var url = "/log/display";

    url = qlist_url_append_arg(url, "log", form.log.value);
    url = qlist_url_append_arg(url, "frame", "search");
    url = qlist_url_append_arg(url, "use_search", "2");

    /* hidden detail frame when open modal*/
    //parent.document.getElementsByTagName("frameset")[0].rows = "*";
    wij_display_modal_dlg(url, { "width": 510, "height": 620 });
}
function logdisplay_except(url)
{
    wij_display_modal_dlg(url, { "width": 350, "height": 180 });
}
function logdisplay_customize_menu(aItems)
{
    var form = document.forms[0];
    var Item;

    Item = Page.createMenuItem({id:"mi_refresh", spriteClass:"tool_retrieve", ctxt: false,
           text:log_strbl.refresh_str, click:{fn: doAction} });
    aItems.push(Item);
    if(parseInt(form.aggregate.value) == 0)
    {
	    Item = Page.createMenuItem({id:"mi_column", spriteClass:"tool_column", ctxt: false,
	           text:log_strbl.column_str, click:{fn: logdisplay_column_setting} });
	    aItems.push(Item);

	    if(parseInt(form.is_detailed.value) == 0)
	    {
		Item = Page.createMenuItem({id:"mi_raw", spriteClass:"tool_file", ctxt: false,
		   text:log_strbl.raw_str, click:{fn: doAction} });
		aItems.push(Item);
	    }else{
		Item = Page.createMenuItem({id:"mi_formatted", spriteClass:"tool_history", ctxt: false,
		   text:log_strbl.formatted_str, click:{fn: doAction} });
		aItems.push(Item);
	    }
	    if(parseInt(form.use_search.value) == 0)
	    {
		Item = Page.createMenuItem({id:"mi_filter", spriteClass:"tool_filter", ctxt: false,
	           text:log_strbl.filter_str, click:{fn: logdisplay_filter_setting} });
		aItems.push(Item);
	/*
		Item = Page.createMenuItem({id:"mi_filter_clear_all", spriteClass:"tool_clear", ctxt: false,
	    	   text:log_strbl.filter_clear_all, click:{fn: doClearAll} });
	   	aItems.push(Item);
	*/
	    }
    }
    if(parseInt(form.logType.value) == 3)
    {
		//if(parseInt(form.use_search.value) == 0)
	    /*    if(parseInt(form.aggregate.value) == 0)
		{
			Item = Page.createMenuItem({id:"mi_merge", spriteClass:"tool_insert", ctxt: false,
			   text:log_strbl.merge_str, click:{fn: logdisplay_merge} });
			aItems.push(Item);
		}
        */
		if(parseInt(form.aggregate.value) == 0)
    	{
			Item = Page.createMenuItem({id:"mi_search", spriteClass:"tool_search", ctxt: false,
			   text:log_strbl.search_str, click:{fn: logdisplay_search} });
			aItems.push(Item);
		}
		if(parseInt(form.use_search.value) == 1 || parseInt(form.use_search.value) == 2)
		{
		    if (is_rw_admin>0)
		    {
			Item = Page.createMenuItem({id:"mi_pdf", spriteClass:"tool_pdf", ctxt: false,
			   text:log_strbl.pdf_str, click:{fn: pdf} });
			aItems.push(Item);
		    }
			Item = Page.createMenuItem({id:"mi_reset", spriteClass:"tool_reset", ctxt: false,
			   text:log_strbl.reset_str, click:{fn: reset} });
			aItems.push(Item);
		}
        if(parseInt(form.aggregate.value) != 0)
        {
            var mMerge = Page.createMenuItem({id:"mi_aggregate_1", spriteClass:"tool_insert", ctxt: false,
               text:fgt_lang.aggregate_1 });

            var subItem = []; {
            var Item;
            Item = Page.createMenuItem({id:"mi_aggregate_3", ctxt: false,
                text:fgt_lang.aggregate_3, click:{fn: function() {logdisplay_aggregate(3) }} });
            subItem.push(Item);
            Item = Page.createMenuItem({id:"mi_aggregate_5", ctxt: false,
                text:fgt_lang.aggregate_5, click:{fn: function() {logdisplay_aggregate(5) }} });
            subItem.push(Item);
            Item = Page.createMenuItem({id:"mi_aggregate_7", ctxt: false,
                text:fgt_lang.aggregate_7, click:{fn: function() {logdisplay_aggregate(7) }} });
            subItem.push(Item);
            }
            mMerge.addSubMenu("mi_aggregate",subItem);
            aItems.push(mMerge);            
        }
/*        
	    if(parseInt(form.aggregate.value) != 0)
	    {
		    Item = Page.createMenuItem({id: "mi_common", spriteClass:"tool_view", ctxt: false, 
				    text: log_strbl.common_str, click: {fn: logdisplay_common}});
		    aItems.push(Item);
	    }
        */
    }
/*
    Item = Page.createMenuItem({id:"mi_filter", spriteClass:"tool_filter", ctxt: false,
           text:log_strbl.filter_str, click:{fn: logdisplay_filter_setting} });
    aItems.push(Item);
*/
    if(parseInt(form.aggregate.value) == 0)
    {
        Item = Page.createMenuItem({id: "mi_manage", spriteClass: "tool_mgmt", ctxt: false,
           text:log_strbl.manage_str, click: {fn: return_main}});
        aItems.push(Item);        
    }

    /*
    if(parseInt(form.logType.value) == 3)
    {
        if(parseInt(form.aggregate.value) == 0)
        {
            var mHide = Page.createMenuItem({id: 'mi_hidesub', spriteClass: 'tool_move', ctxt: false,
                text: 'Select Events'
            });

            var subs = [];
            Item = Page.createMenuItem({id: 'mi_match_event', ctxt: false,
                text: 'Match Event', click: {fn: function() {logdisplay_hidesub(1);}}
            });
            subs.push(Item);

            Item = Page.createMenuItem({id: 'mi_all_event', ctxt: false, 
                text: 'All Event', click: {fn: function() {logdisplay_hidesub(0);}}
            });
            subs.push(Item);

            mHide.addSubMenu("mi_hidesub1", subs);
            aItems.push(mHide);
        }
    }
    */
}

function logfilterSetup(tableId, columnsArray, cookieName)
{
    // convert columns
    filter_settings.logColumns = columnsArray;
    var columns = [], col;
    for (var i = 0; (col = columnsArray[i]); i++) {
        if (col[0] == "pri" || col[0] == "utm_type")
            type = [col[2], DISPLAY_FILTER_TYPE_SELECT_MULTIPLE];
        else if (col[0] == "time")
            type = [FIELD_TYPE_TIME, 0];
        else if (col[0] == "date")
            type = [FIELD_TYPE_DATE, 0];
        else if (col[0] == "pri")
            type = [FIELD_TYPE_DATE, 0];
        else if (col[2] >= logdisplay_opts.LOG_FIELD_TYPE_UINT8 && col[2] <= logdisplay_opts.LOG_FIELD_TYPE_UINT32)
            type = [FIELD_TYPE_INTEGER, 0];
        else
            type = [col[2], 0];
        columns.push([col[0], col[1], type, col[3]]);
    }

    // parse cookie filter
    var logType = logdisplay_opts.type;
    var logFilterCookieString = getCookie(cookieName);
    var logFilterCookieArray = deserializeArray(logFilterCookieString ? logFilterCookieString : "");
    var logFilterArray = logFilterCookieArray[logType];
    if (!logFilterArray) logFilterArray = [];
    var flt;
    for (var i = 0; (flt = logFilterArray[i]); i++) {
        logFilterArray[i] = {
            "id": flt[0],
            "logic": {
                "NOT": flt[2],
                "OR": flt[1] != true,
                "RANGE": flt[1]
            },
            "value": flt[5] && flt[5].length ? flt[5] : [flt[3], flt[4]]
        };
    }


    // set filter column
    $j(tableId).filterConsole({
        "lang": {
                "heading": flt_lang["filter"]["heading"],
                "ok": flt_lang["filter"]["ok"],
                "apply": flt_lang["filter"]["apply"],
                "cancel": flt_lang["filter"]["cancel"],
                "from": flt_lang["filter"]["from"],
                "to": flt_lang["filter"]["to"],
                "format": flt_lang["filter"]["format"],
                "value": flt_lang["filter"]["value"],
                "change": flt_lang["filter"]["change"],
                "fieldName": flt_lang["filter"]["fieldName"],
                "input": flt_lang["filter"]["input"],
                "select": "[ "+flt_lang["filter"]["select"]+" ]",
                "addFilter": flt_lang["filter"]["addFilter"],
                "clearFilter": flt_lang["filter"]["clearFilter"],
                "rmHint": flt_lang["filter"]["rmHint"]
        },
        "columns": fieldColumnParse(columns),
        "filters": logFilterArray,
        "expanded": filterExpaned,
        "action": logfilterOK
    });
}

var formatter = FOSGUI.LogFormatter.getFormatter();

function logdisplay_onload()
{
    qlist_obj.customize_menu_fn = logdisplay_customize_menu;
    qlist_obj.create_new = false;
    qlist_obj.create_edit = false;
    qlist_obj.create_del = false;
    qlist_obj.disable_context_menu = true;

    qlist_obj.enable_ref_col = false;
    qlist_setup("contentBody", "", "");
    //fixup_droplist_alignment($j("mi_detail_v"));    

    // Move the column chooser & other misc items into the header bar.
    $j('#qlist_right_menubar_container').append($j('#extra_right_hdr_items'));
    $j('#extra_right_hdr_items').css('visibility', 'visible');

    //movePaging($j('paging_row'));
    $j('#ftrtc').append($j('#paging_row'));
    $j('#paging_row').css('visibility', 'visible');

    //if(parseInt(document.forms[0].logType.value) != 1)
    {
	// enable the log details pop-out
	$j("tr", "#contentBody").live("click", DetailsWindow.click);
	$j(document).keydown(DetailsWindow.keypress);
    }

    // set filter column
    if(typeof(filter_columns) != "undefined")
        logfilterSetup("#qlist_hdrrow", filter_columns, filterCookieName);

    $j("td", "#contentBody").live("mouseover", function() {
        var text = $j(this).text();

        if (text != "") {
            $j(this).attr("title", $j(this).text());
        }
    });

    if(parseInt(document.forms[0].is_detailed.value) == 1)
	   $j("#contentBody").removeClass("oneline");
    else
	   $j("#contentBody").addClass("oneline");	

    var column_lang = {};

    if (document.forms[0] && document.forms[0].log) {
        column_lang = fgt_lang[ document.forms[0].log.value ];
    }

    DetailsWindow.initialize({
        containerSelector : "body",
        mainPanelSelector : "#main_window",
        detailsPanelSelector : "#logview-details",
        contentBodySelector: '#contentHead',
        detailsLocation : "east",
        isShowThreatDetails:false,
        formatCallbacks : formatter,
        rowData : log_formatted,
        langOverride : column_lang
    });
	
    $j('#qlist_hdrbar').width($j('#tableContainer').width());
    $j('#qlist_ftrbar').width($j('#tableContainer').width());
    /*adjust table width*/
    $j('#tableContainer').find('th').resize(function() {
        $j('#qlist_hdrbar').width($j('#tableContainer').width());
        $j('#qlist_ftrbar').width($j('#tableContainer').width());
    });

    $j('#tableContainer').attr('style','overflow-y:auto');
    $j('#tableContainer').height($j('#main_window').height()-60);
}

/* log management */
function return_main() {
	parent.log.location = "/log/disk/list?log="+document.forms[0].logdisk.value;
}

/* clear all filter*/
function doClearAll() {
	var logType = document.forms[0].logType.value;
	var logFilterCookieName = document.forms[0].logFilterCookieName.value;
	var logFilterCookieString = getCookie(logFilterCookieName);
	var logFilterCookieArray;

	if (!logFilterCookieString) {
		logFilterCookieString = "&&&&&&&";
	}

	logFilterCookieArray = deserializeArray(logFilterCookieString);
	logFilterCookieArray[logType] = "";
	setCookie(logFilterCookieName, serializeArray(logFilterCookieArray));
	parent.log.location.replace(parent.log.location.href + '&newfilter=1');
}
/**
 * 分页函数
 * pno--页数
 * psize--每页显示记录数
 * 分页部分是从真实数据行开始，因而存在加减某个常数，以确定真正的记录数
 * 纯js分页实质是数据行全部加载，通过是否显示属性完成分页功能
 **/
function goPage(pno,psize,pageup,pagedown,pagetext){
	var itable = document.getElementById("contentBody");
	var num = itable.rows.length;//表格行数
	var totalPage = 0;//总页数
	var pageSize = psize;//每页显示行数
	if((num-1)/pageSize > parseInt((num-1)/pageSize)){   
   		 totalPage=parseInt((num-1)/pageSize)+1;   
   	}else{   
   		totalPage=parseInt((num-1)/pageSize);   
   	}   
	var currentPage = pno;//当前页数
	var startRow = (currentPage - 1) * pageSize+1;//开始显示的行   
   	var endRow = currentPage * pageSize+1;//结束显示的行   
   	var form = document.forms[0];
   	var startline_val = parseInt(form.startline.value); //数据库查询开始行
   	var viewlines_val = parseInt(form.viewlines.value); //数据库查询数
   	endRow = (endRow > num)? num : endRow;
	//第一行始终显示

	var is_ie6or7 = false;
	if(navigator.userAgent.indexOf("MSIE 6.0") > 0 || navigator.userAgent.indexOf("MSIE 7.0") >0 )	is_ie6or7 = true;

	for(i=0;i<1;i++){
		var irow = itable.rows[i];
		if(is_ie6or7)
			irow.style.display = "inline";
		else
			irow.style.display = "table-row";
	}
	
	for(var i=1;i<num;i++){
		var irow = itable.rows[i];
		if(i>=startRow&&i<endRow){
			if(is_ie6or7)
				irow.style.display = "inline";
			else
				irow.style.display = "table-row";
		}else{
			irow.style.display = "none";
		}
	}
	//var tempStr = "共"+(num-1)+"条记录 分"+totalPage+"页 当前第"+currentPage+"页";
    var globalPage = parseInt(startline_val/viewlines_val+currentPage);
	var tempStr = ""+ globalPage + "&nbsp;&nbsp;" + pagetext + "&nbsp;&nbsp;&nbsp;&nbsp;";
	if(currentPage>1){
		tempStr += "<img src=\"/images/play_prev.gif\" style=\"cursor: pointer\" alt=\""+pageup+"\" title=\""+pageup+"\" onClick=\"goPage("+(currentPage-1)+","+psize+",'"+pageup+"','"+pagedown+"','"+pagetext+"')\">";
	}else if(startline_val < viewlines_val){
		tempStr += "<img src=\"/images/play_prev.gif\" style=\"cursor: pointer\" alt=\""+pageup+"\" title=\""+pageup+"\" class=\"list_button_disabled\">";
	}else{
		tempStr += "<img src=\"/images/play_prev.gif\" style=\"cursor: pointer\" alt=\""+pageup+"\" title=\""+pageup+"\" onClick=\"doAction(0)\" >";
	}

	if(currentPage<totalPage){
		tempStr += "&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/images/play_next.gif\" style=\"cursor: pointer\" alt=\""+pagedown+"\" title=\""+pagedown+"\" onClick=\"goPage("+(currentPage+1)+","+psize+",'"+pageup+"','"+pagedown+"','"+pagetext+"')\">";
	}else if(endRow == currentPage*viewlines_val+1){
		tempStr += "&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/images/play_next.gif\" style=\"cursor: pointer\" alt=\""+pagedown+"\" title=\""+pagedown+"\" onClick=\"doAction(1)\">";	
	}else{
		tempStr += "&nbsp;&nbsp;&nbsp;&nbsp;<img src=\"/images/play_next.gif\" style=\"cursor: pointer\" alt=\""+pagedown+"\" title=\""+pagedown+"\" class=\"list_button_disabled\">";	
	}
    tempStr += "<input name=\"currentPage\" type=\"hidden\" value=\""+currentPage+"\">";
	document.getElementById("search_page_bar").innerHTML = tempStr;	
    /*for select all*/
    document.getElementById("selectAll").checked = false;
    for(var i = (currentPage-1)*viewlines_val+startline_val; i < currentPage*viewlines_val+startline_val; i++)
    {
        var o = document.getElementById("enable_" + i);
        if(o)o.checked = false;
    }
}
