(function($) {

    function text(obj, def) { return obj || def || ""; }

    $.fn.filterConsole = function(settings) {
        var config = {
            "lang": {
                "heading" : "Filters",
                "ok" : "OK",
                "apply" : "Apply",
                "cancel": "Cancel",
                "from": "From",
                "to": "To",
                "format": "Format",
                "value": "Value",
                "change": "Change",
                "fieldName": "Field",
                "input": "Or, search below",
                "select": "[ Please Select ]",
                "addFilter": "Add new filter ...",
                "clearFilter": "Clear all filters",
                "rmHint": "Remove Filter"
            },
            "panelClass" : "filterConsolePanel",
            "targetSelector" : 'th img[src*="filter"]',
            // default expanded filter name
            "expanded": "",
            // columns, [ {key, label, support{NOT, OR, RANGE}, selection[]/{}, validate(oflt)}, ... ]
            "columns" : [],
            // filters, [ {id, logic{NOT, OR, RANGE}, value}, ... ]
            "filters": [],
            "action": function(panel) {}
        }

        $.extend(config, settings);

        // Deprecate: setup a way for external scripts to get the current filters list
        // should use $j().filterSection(callback) to receive current filters
        window.getFilters = function () {
            return config.filters;
        }

        config.columns = config.columns.sort(function (a, b) {
            return a.label > b.label ? 1 : (a.label < b.label ? -1 : 0);
        });

        // lookup filter
        function filterGetFilter(fieldName) {
            var flt;

            for (var i = 0; (flt = config.filters[i]); i++) {
                if (flt.id == fieldName) {
                    return flt;
                }
            }
            return {};
        }

        // lookup column
        function filterGetField(fieldName) {
            var flt;
            for (var i = 0; (flt = config.columns[i]); i++) {
                if (flt.key == fieldName || flt.label == fieldName)
                    return flt;
            }
            return {};
        }

        this.each(function() {
            var panel = $(setupFilterPanel());
            var thead = $("tr:first", this);
            panel.insertAfter(thead)
                .wrap("<tr style='display: none'><td class=filterConsole colspan=\"" + thead.get(0).cells.length + "\"></td></tr>");

            // filter icon click
            $(config.targetSelector, this).live("click", filterClickHandler);

            // filter apply
            $("form", panel).submit(function() { return config.action(panel) });

            // cancel click
            $("input[value='"+config.lang.cancel+"']", panel).click(function () {
                hideConsole();
                filterClearFilter();
                filterBuildFilter();
            });
            // apply click
            $("input[value='"+config.lang.apply+"']", panel).click(function () {
                var sec = $(".filterSectionSelected", panel);
                var fieldName = sec.attr("fieldName");
                var form = $("form", panel);
                $("input[name=expanded]", form).val(fieldName ? fieldName : ".");
            });

            $(".filterEdit", panel).hide();
            var secs = $("ul>li.filterSection", panel);
            /*
            $(".filterLabel>a", secs).live("click", filterShowFilter);
            $(".filterLabel .icon_sprite", secs).live("click", filterOperation);
            $(".option_button", secs).live("click", filterOptionMove);
            $(".option_select", secs).live("dblclick", filterOptionMove);
            */
            $(".filterLabel>a", this).live("click", filterShowFilter);
            $(".filterLabel .icon_sprite", this).live("click", filterOperation);
            $(".option_button", this).live("click", filterOptionMove);
            $(".option_select", this).live("dblclick", filterOptionMove);

            // setup new filter name action
            $("select[name=_field_name]", secs).change(function () {
                if (filterGetField(this.value).key) filterEditFilter(this.value);
            });
            $("input[name=_field_name]", secs).autocomplete(config.columns, {
                "formatItem": function (flt) {
                    return $(".filterSection[fieldName="+flt.key+"]", panel).length ? false : (flt.label + " (" + flt.key + ")");
                },
                "matchContains": true,
                "width": 300
            }).result(function (e, v) {
                this.value = v.label;
                // delay show filter avoid input focus error (IE)
                if (this.value) setTimeout(function() { filterEditFilter(v.label); }, 0);
            });

            // load filters
            filterBuildFilter();

            // if section provided, expand it
            if (config.expanded) {
                panel.show();
                panel.parents("tr:first").show();
                alignPanel();
                var sec = $(".filterSection[fieldName='"+config.expanded+"']", panel);
                // activate
                $(".filterLabel>a", sec).click();
            }

            // call specific functions

            function filterOperation() {
                // clear filters
                if ($(this).hasClass("tool_clear"))
                    return filterClearFilter();
                // delete filter
                if ($(this).hasClass("tool_x_red"))
                    $(this).parents(".filterSection:first").remove();
            }

            function filterClearFilter() {
                $(".filterSection", panel).each(function () {
                    if (!$("[name=_field_name]", this).length)
                        $(this).remove(); 
                });
            }

            function filterBuildFilter() {
                // append cookie filters to filter panel
                var flt;
                for (var i = config.columns.length - 1; i >= 0 && (flt = config.columns[i]); i--) {
                    // try to load from cookie
                    var oflt = filterGetFilter(flt.key);
                    if (oflt.value != undefined) {
                        var sec = $(setupFilterSection(flt, oflt));
                        $("ul", panel).prepend(sec);
			// added by lk, rewrite the value field, otherwise may display escaped code here
			$(".filterLabel .filterText", sec).text(flt.text);
                        extendFilter(sec, flt, oflt);
                    }
                }

            }

            // filter extension
            function extendFilter(sec, flt, oflt)
            {
                // tag extension
                if (flt.selection && flt.selection.tags)
                    TagSelector.init({ "appliedTags": oflt.value, "readOnly": 1 });

                if (!flt.is) return;

                if (flt.is.date)
                {
                    var dates = $('input[name$="_from_value"], input[name$="_to_value"]', sec).datepicker({
                            "onSelect": function(selectedDate) {
				var option = this.name.indexOf("_from_value") > 0 ? "minDate" : "maxDate",
                                instance = $(this).data("datepicker"),
                                date = $.datepicker.parseDate(
                                    instance.settings.dateFormat ||
                                    $.datepicker._defaults.dateFormat,
                                    selectedDate, instance.settings);
                                dates.not(this).datepicker("option", option, date);
			    }
                        });

                    var arr = [];
                    // convert date formate to locale format
                    if (oflt.value[0]) arr[0] = $.datepicker.parseDate("yy-mm-dd", oflt.value[0]);
                    if (oflt.value[1]) arr[1] = $.datepicker.parseDate("yy-mm-dd", oflt.value[1]);

                    $('input[name$="_from_value"]', sec).datepicker("setDate", arr[0]);
                    $('input[name$="_to_value"]', sec).datepicker("setDate", arr[1]);
                }

            }

            function collapseFilter(sec, remove)
            {
                // update filter caption display
                var fieldName = sec.attr("fieldName");
                if (fieldName) {
                    var flt = filterGetField(fieldName);
                    var oflt = getSecFilter(flt.key, panel);
                    // some verify on section before it lost focus
                    if (flt.validate && !flt.validate.call(sec, oflt))
                        return false;
                    // remove filter if no value
                    if ((!oflt.value || !oflt.value.join("")) && remove) {
                        sec.remove();
                    }
                    else {
                        // show "[change]"
                        $(".filterLabel>a", sec).show();
                        // dynamical get the flt.text to display
                        setupFilterSection(flt, oflt);
                        $(".filterLabel .filterText", sec).text(flt.text);
                    }
                }
                // clear last select section
                sec.removeClass("filterSectionSelected");
                $(".filterEdit", sec).hide();

                return true;
            }

            function expandFilter(sec)
            {
                // display newly activate section
                sec.addClass("filterSectionSelected");
                if ($("[name=_field_name]", sec).size() > 0) {
                    // refresh new filter list
                    var html = "<option value=''>"+config.lang.select+"</option>";
                    for (var i = 0; (flt = config.columns[i]); i++) {
			if(flt.key == 'log_type')	continue;
                        if (!$(".filterSection[fieldName="+flt.key+"]", panel).length)
                            html += "<option value=\""+flt.key+"\">"+flt.label+" ("+flt.key+")</option>";
                    }
                    var sel = $("select[name=_field_name]", sec).html(html);
                }
                else {
                    // hide [change]
                    $(".filterLabel>a", sec).hide();
                }
            }

            function filterShowFilter() {
                // current actived section
                var sec = $(".filterSectionSelected", panel);
                // section to be shown
                var fltSec = $(this).parents(".filterSection:first");

                // collaps old section
                if (!collapseFilter(sec, sec[0] != fltSec[0]))
                    return false;

                // display newly activate section
                expandFilter(fltSec);

                if (panel.is(":visible")) {
                    $(".filterEdit", fltSec).slideDown("fast", function () {
                        $(":input:not([type=checkbox]):first", fltSec).focus(); });
                }
                else {
                    $(".filterEdit", fltSec).show();
                }

                return false;
            }

            function filterEditFilter(fieldName) {
                // lookup by field text
                var flt = filterGetField(fieldName);

                var sec;
                // select corresponding section
                $(".filterSection", panel).each(function () {
                    sec = $(this);
                    if (sec.attr("fieldName") == flt.key) {
                        return false;
                    }
                });

                // if activate sec is new filter section
                if (flt.key && $("[name=_field_name]", sec).val("").size() > 0) {
                    // generate new filter section according to flt
                    var oflt = filterGetFilter(flt.key);
                    sec = $(setupFilterSection(flt, oflt)).insertBefore(sec);
                    extendFilter(sec, flt, oflt);
                }

                // activate
                $(".filterLabel>a", sec).click();
            }

            function filterOptionMove() {
                var sec = $(".filterSectionSelected", panel);
                var fieldName = sec.attr("fieldName");

                return this.name.indexOf("_available_list") > 0 || this.value.indexOf("->") > 0 ?
                    moveOptions($("select[name="+fieldName+"_available_list]", sec).get(0), $("select[name="+fieldName+"_value_list]", sec).get(0))
                    : moveOptions($("select[name="+fieldName+"_value_list]", sec).get(0), $("select[name="+fieldName+"_available_list]", sec).get(0));
            }

            function filterClickHandler(evt) {

                // use the attribute if present, otherwise try to match the labels
                var fieldText = $.trim($(this).parent().text());

                filterEditFilter(fieldText);

                togglePopout(true);

                return false;
            }

            function alignPanel() {
                // test if panel width align well
                var w = panel.parents("tr:first").width() - panel.outerWidth(true);
                if (Math.abs(w) > 10) {
                    // panel's width need to align manually, log viewer, why?
                    panel.width(panel.parents("tr:first").width() - (panel.outerWidth(true) - panel.width()));
                }
            }

            function togglePopout(state) {
                // tr of panel
                var body = panel.parents("tr:first");

                if (state == undefined)
                    state = panel.is(":hidden");

                if (state) {
                    if (panel.is(":hidden")) {
                        body.show();
                        // make panel visible
                        panel.height(0).show();
                        alignPanel();
                        panel.hide().height("auto");

                        panel.slideDown("slow", function() {
                            // slide smooth: input focus AFTER slide down
                            $(".filterSectionSelected :input:not([type=checkbox]):first", panel).focus(); });
                    }
                } else {
                    panel.slideUp("slow", function() {
                        body.hide(); });
                }

                return state;
            }

            function hideConsole(evt) {
                togglePopout(false);

                return false;
            }

            this.togglePopout = togglePopout;
        });

        // generating filter section html code
        // flt: column object, oflt: filter object
        function setupFilterSection(flt, oflt) {
            // init
            if (oflt.logic == undefined)
                oflt.logic = {};
            else {
                // force covert to boolean
                oflt.logic.NOT = oflt.logic.NOT == true;
                oflt.logic.RANGE = oflt.logic.RANGE == true;
                oflt.logic.OR = oflt.logic.OR == true;
            }
            if (oflt.value == undefined) oflt.value = [];
            if (typeof(oflt.value) == "string") oflt.value = [oflt.value];

            flt.text = oflt.logic.NOT ? "NOT " : "";
            // selection like type
            if (flt.selection) {
                // tags selection
                if (flt.selection.tags) {
                    flt.text += oflt.value.join("").length ? oflt.value.join(" OR ") : "";
                    flt.html = getTagUI();
                }

                // regular selection
                else if (!flt.support.OR) {
                    // single selection
                    var opt;

                    flt.html = "<p>"+config.lang.value+": <select name="+flt.key+"_text_value>"
                        for (var i = 0; (opt = flt.selection[i]); i++) {
                            var slt;
                            if (typeof(opt) == "string") opt = [opt];
                            if (!oflt.value || (","+oflt.value.join(",")+",").indexOf(","+opt[0]+",") < 0)
                                slt = "";
                            else {
                                flt.text += text(opt[1], opt[0]);
                                slt = " selected";
                            }
                            flt.html += "<option value=\"" + opt[0] + "\"" + slt + ">" + text(opt[1], opt[0]) + "</option>";
                        }
                    flt.html += "</select></p>";
                }
                else {
                    // multiple selection
                    var opt, avl_opts = "", slt_opts = "";
                    for (var i = 0; (opt = flt.selection[i]); i++) {
                        if (typeof(opt) == "string") opt = [opt];
                        var s = "<option value=\"" + opt[0] + "\">" + text(opt[1], opt[0]) + "</option>";
                        if (!oflt.value || (","+oflt.value.join(",")+",").indexOf(","+opt[0]+",") < 0) {
                            avl_opts += s;
                        }
                        else {
                            flt.text += (slt_opts ? ", " : "") + text(opt[1], opt[0]);
                            slt_opts += s;
                        }
                    }

                    flt.html = "<table>"
                        + "<tr><td colspan=2></td><td><label><input name="+flt.key+"_negate type=checkbox"+(oflt.logic.NOT ? " checked" : "")+"> NOT</label></td></tr>"
                        + "<tr><td><select name="+flt.key+"_available_list class=option_select size=10 multiple>"
                        + avl_opts
                        + "</select></td>"
                        + "<td><div>"
                        + "<input type=button class=option_button value=\" -> \"><br>&nbsp;<br>"
                        + "<input type=button class=option_button value=\" <- \"></div></td>"
                        + "<td><select name="+flt.key+"_value_list class=option_select size=10 multiple>"
                        + slt_opts
                        + "</select></td>"
                        + "</tr></table>";
                }
            }

            // int like type
            else if (flt.support.RANGE) {
                var val_text = "";

                if (oflt.value.join("").length) {
                    if (oflt.logic.OR) {
                        val_text = oflt.value.join(", ")
                        flt.text += oflt.value.join(" OR ");
                    }
                    else {
                        if (!oflt.value[0])
                            val_text = " <= " + oflt.value[1];
                        else if (!oflt.value[1])
                            val_text = " >= " + oflt.value[0];
                        else
                            val_text = oflt.value.join(" - ");
                        flt.text += val_text;
                    }
                }

                if (!flt.support.OR) {
                    // just range only, show from - to
                    flt.html = "<table cellspacing=0 colspacing=0>"
                        + "<tr><td></td><label><input name="+flt.key+"_negate type=checkbox"+(oflt.logic.NOT ? " checked" : "")+"> NOT</label></td></tr>"
                        + "<tr><td>"+config.lang.from+":</td><td><input name="+flt.key+"_from_value class=dateInput size=10 value=\""+text(oflt.value[0])+"\"></td></tr>"
                        + "<tr><td>"+config.lang.to+":</td><td><input name="+flt.key+"_to_value class=dateInput size=10 value=\""+text(oflt.value[1])+"\"></td></tr>"
                        + "</table>";
                }
                else {
                    // range/or, show input box
                    flt.html = "<p>"+config.lang.value+": <input name="+flt.key+"_text_value class=textInput value=\""+val_text+"\">"
                        + " <label><input name="+flt.key+"_negate type=checkbox"+(oflt.logic.NOT ? " checked" : "")+"> NOT</label></p>";
                }
            }

            // string like type
            else {

                // default input
                flt.text += oflt.value.join("").length ? (
                                oflt.value.length > 1 ? oflt.value.join(" OR ") : oflt.value[0].replace(/^\s|\s$/, "").split(" ").join(" AND ")
                            ) : "";

                flt.html = "<p>"+config.lang.value+": <input name="+flt.key+"_text_value class=textInput value=\""+(oflt.value ? oflt.value.join(", ") : "")+"\">"
                    + " <label><input name="+flt.key+"_negate type=checkbox"+(oflt.logic.NOT ? " checked" : "")+"> NOT</label></p>";
            }
            
            // help
            flt.html += "<p>" + text(flt.help) + "</p>";

            var html = "<li class=filterSection fieldName='"+flt.key+"'>";

            html += "<div class=filterLabel>"
                + "<div class=icon><b class='icon_sprite tool_x_red' title='"+config.lang.rmHint+"'></b></div>"
		// modified by lk, must escape the value, or use $() will occurs error
                + "<span><b>" + flt.label + "</b>:</span><span class=filterText>" + escape(flt.text) + "</span> <a href=.>["+config.lang.change+"]</a>"
                + "</div>";

            html += "<div class=filterEdit style='display:none'>" + flt.html + "</div>";

            html += "</li>";

            return html;
        }

        // setup functions

        function setupFilterPanel(panel) {
            var flt;

            var html = "<div class=\"" + config.panelClass + "\" style='display: none'>"
                + "<h3>" + config.lang.heading + ":</h3>"
                + "<form>"
                + "<ul>";
                
            // add new filter
            html += "<li class=filterSection>"
                + "<div class=filterLabel><a><div class=icon><b class='icon_sprite tool_add'></b></div></a>"
                + "<span class=filterText>" + config.lang.addFilter + "</span></div>"
                + "<div class=filterEdit>"
                + "<p>" + config.lang.fieldName + ": ";

            html += "<select name=_field_name>";
            html += "</select></p>";

            html += "<p>" + config.lang.input + ": "
                + "<br><input name=_field_name class=textInput>"
                + "</p>";

            html += "</div>"
                + "</li>";

            // clear all filter
            html += "<li>"
                + "<div class=filterLabel><div class=icon><b class='icon_sprite tool_clear'></b></div><span class=filterText>" + config.lang.clearFilter + "</span></div>"
                + "</li>";

            // end filter section
            html += "</ul>"
                + "<input name=expanded type=hidden>"
                + "<p>"
                + "<input class=\"button\" type=\"submit\" value=\"" + config.lang.ok + "\" />\n"
                + "<input class=\"button\" type=\"submit\" value=\"" + config.lang.apply + "\" />\n"
                + "<input class=\"button\" type=\"button\" value=\"" + config.lang.cancel + "\" />\n"
                + "</p>"
                + "</form>"
                + "</div>";

            return $(html);
        }

        // tags selection html
        function getTagUI()
        {
            return "<div id=tags_ui><table>"
                + "<tr>"
                + "<td><label for=\"appliedTags\" lang_key=\"applied_tags\">" + config.lang["applied_tags"] + ":</label></td>"
                + "<td><span id=\"appliedTags\"></span></td>"
                + "</tr>"
                + "<tr>"
                + "<td><label for=\"addTag\" lang_key=\"tags_to_add\">" + config.lang["tags_to_add"] + ":</label></td>"
                + "<td><input name=\"addTag\" id=\"addTag\" type=\"text\" /></td>"
                + "</tr>"
                + "<tr>"
                + '<td><label for="popularTags" lang_key="click_to_add">' + config.lang["click_to_add"] + ':</label></td>'
                + '<td><span id="popularTags"></span></td>'
                + "</tr>"
                + "</table></div>";
        }

        $.fn.filterPopout = function(state) {
            this.each(function () {
                this.togglePopout(state);
            });
        };

        function getSecFilter(fieldName, panel) {
            var sec = $(".filterSection[fieldName="+fieldName+"]", panel);
            if (!sec.length) return {};

            var f = $("form", panel).get(0);
            var flt = filterGetField(fieldName);
            var oflt = {
                "id": fieldName,
                "logic": {}
            };

            if (f[fieldName + "_negate"] && f[fieldName + "_negate"].checked)
               oflt.logic.NOT = 1;

            // selection case
            if (flt.selection) {
                // tag selection
                if (flt.selection.tags) {
                    oflt.value = TagSelector.getAppliedNameList();
                }
                // single selection
                else if (!flt.support.OR) {
                    oflt.value = [f[fieldName + "_text_value"].value];
                }
                else {
                    // multiple selection
                    oflt.value = optionToString(optionsToArray(f[fieldName + "_value_list"], 2, 0));
                }

                oflt.logic.OR = oflt.value.length > 1;
            }

            // int case
            else if (flt.support.RANGE) {
                if (!flt.support.OR) {
                    oflt.logic.RANGE = 1;
                    oflt.value = [
                        f[fieldName+"_from_value"].value,
                        f[fieldName+"_to_value"].value
                    ];
                }
                else {
                    oflt.value = f[fieldName + "_text_value"].value.split(",");
                    if (oflt.value.length > 1) {
                        oflt.logic.OR = 1;
                    }
                    else {
                        var arr, val = oflt.value[0];
                        // test operator
                        if (val.indexOf("-") >= 0) {
                            arr = val.split("-");
                        }
                        else if (val.indexOf(">=") >= 0) {
                            arr = val.split(">=");
                            arr[0] = arr[1];
                            arr[1] = "";
                        }
                        else if (val.indexOf(">") >= 0) {
                            arr = val.split(">");
                            arr[0] = ++arr[1];
                            arr[1] = "";
                        }
                        else if (val.indexOf("<=") >= 0) {
                            arr = val.split("<=");
                        }
                        else if (val.indexOf("<") >= 0) {
                            arr = val.split("<");
                            arr[1]--;
                        }

                        if (arr && arr.length > 1) {
                            oflt.logic.RANGE = 1;
                            oflt.value = arr;
                        }
                    }
                }
            }

            // string case
            else {

                oflt.value = f[fieldName + "_text_value"].value.split(",");

                oflt.logic.OR = oflt.value.length > 1;
            }

            // clean up values
            for (var i = 0; i < oflt.value.length; i++) {
                oflt.value[i] = oflt.value[i].toString().replace(/[\'\"]+/g, " ").replace(/^\s+|\s+$/, "");
            }

            // filter extension
            if (flt.is) {
                // datepicker extension
                if (flt.is.date) {
                    // convert date formate to yyyy-mm-dd
                    oflt.value[0] = $.datepicker.formatDate("yy-mm-dd", $(f[fieldName+"_from_value"]).datepicker("getDate"));
                    oflt.value[1] = $.datepicker.formatDate("yy-mm-dd", $(f[fieldName+"_to_value"]).datepicker("getDate"));
                }
            }

            return oflt;
        }

        $.fn.filterSection = function(callback) {
            this.each(function () {
                var panel = $(this);
                $(".filterSection", panel).each(function () {
                    var fieldName = $(this).attr("fieldName");
                    if (!fieldName) return;
                    return callback.call(this, getSecFilter(fieldName, panel));
                });
            });
        };

        return this;
    };

})(jQuery);
