/*
  clientlogreport.js - misc JS code for clientlogreport.c
  init Mar 2011 by Jianjiang Yan
  GUI redesign project
  Copyright Fortinet Inc
*/
function logreport_edit_elems(q, elem)
{
//    if (aElems.length != 1) return;

    var mkey = elem.getAttribute("mkey");

    $j.submitPOST(logreport_url+"_edit?act=edit&rdn=" + mkey+"&session_id="+session_id);
}
function logreport_delete_elems(q, aElems)
{   
    var logreport_delete_url = logreport_url+"_act?act=del&session_id="+session_id;
    var len = aElems.length;
    for (var i=0; i<len; i++)
    {
        var mkey = aElems[i].getAttribute("mkey");
//	if(parseInt(aElems[i].getAttribute("can_run")) == 1)
        logreport_delete_url += "&rdn=" + mkey;	
    }

    $j.submitPOST(logreport_delete_url);
}

function logreport_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
	
    if(!is_rw_admin)
    {
	qmenu_enable_button($j("#mi_view"), true, q);
	return;
    }

    if (aElems.length >0 && parseInt(aElems[0].getAttribute("can_run")) == 1)
    {
	if(aElems.length == 1 ) 
	{
		qmenu_enable_button($j("#mi_run"), true, q);
	        qmenu_enable_button($j("#mi_edit"), true, q);
	}else{
		qmenu_enable_button($j("#mi_run"), false, q);
        	qmenu_enable_button($j("#mi_edit"), false, q);		
	}	
        qmenu_enable_button($j("#mi_del"), true, q);
    }else{
	qmenu_enable_button($j("#mi_run"), false, q);
	qmenu_enable_button($j("#mi_edit"), false, q);
        qmenu_enable_button($j("#mi_del"), false, q);
    }

    if(aElems.length > 0)
    {
	    qmenu_enable_button($j("mi_del"), true, q);
    }
}

function logreport_onclick_run()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");

    $j.submitPOST("/clientlog/report/report_act?act=newrun&rdn=" + mkey + "&session_id="+session_id);
}

// logreport_menu - Override the default menubar to add button "run".
function logreport_menu(aItems)
{
    if (is_rw_admin) {
        var mNew = Page.createMenuItem({id:"mi_run", spriteClass:"tool_run", ctxt:true,
                   text:logreport_strtbl.run, click:{fn: logreport_onclick_run} });
        aItems.push(mNew);
    }
}

// logreportlist_onload - onload handler for the clientlogreport list page.
function logreportlist_onload()
{
    var logreport_create_url = logreport_url+"_act?act=new";
    // Customize the qlist definition.
    qlist_obj.customize_menu_fn = logreport_menu;
    qlist_obj.handle_selection_change_fn = logreport_handle_selection_change;

    qlist_obj.edit_elem_fn = logreport_edit_elems;
    qlist_obj.delete_elems_fn = logreport_delete_elems;
    qlist_setup("qlist", logreport_create_url, logreport_create_url,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", logreportlist_onload);

// Move the column chooser into the header bar.
qlist_add_header_extra($j("#extra_hdr_items")[0], $j("#report_run")[0]);
