
var action_settings = (function($) {
	'use strict';

	function _in_onload(type, $inline) {
		$('.ql-body-container').css('overflow', 'inherit');
		$('.toggle-switch', $inline).change(function() {
			var $parent = $(this).parents('tr');

			// Prevent disabled entries from using inline edit support.
			var can_edit = ($parent.attr('can_edit') === '1') ? '0' : '1';
			$parent.attr('can_edit', can_edit);
			if(can_edit === '1')
				$parent.removeClass('disabled');
			else
				$parent.addClass('disabled');
		});

		$inline.find('.ql-head-container').css('display','none'); 

		//if(type == 'cookie_poison' || type == 'xml_protocol' || type == 'json_protocol')
		if(type == 'json_action')
		{	
			// Range validation for block_period
			$('td.block_period input[type=number]',$inline).attr({
				'min': 1,
				'max': 3600
			});

			$('td.action select[data-name=action]', $inline).on('change', function() {
				var $parent = $(this).parents('tr');
				var id = $parent.attr('data-row-handler-id');

				var val = ($(this).val());
				var $block = $('td.block_period input#'+type+'-'+id+'-block_period', $inline);
				$block.attr('disabled', val === '11' ? false: true);
			}); 

		}
		$('td.block_period input', $inline).each(function(){
			var $parent = $(this).parents('tr');
			var id = $parent.attr('data-row-handler-id');
			var action = $('td.action select', $parent).val();
			$(this).attr('disabled', action === '11' ? false: true);
		}); 
	}

	function configure_action(type, $container, $entries) {
		// 'inline-mode' defaults to 'continous' and is configurable from
		// the CLI only.

		var options = {
			// List of inline-table  is resizeable.
			'hide_create_button': true,
			'hide_delete_button': true,
			'fixed_header': false,
			'css_layout': false,
			//'hide_menu': true,
		};

		var format_fn = {
			// A format function is provided to override the default
			// inline editing capabilities for this field.
			'name': function(td, column, entry) {
				return entry.name;
			},
		};

		var action_options = {};
		var columns = [];

		switch(type)
		{
			case 'json_action':
				action_options = options_action;
				columns = [
					{'selector': 'name', 'lang_key': $j.getInfo('name'), 'width': '28.75%'},
					{'selector': 'action', 'lang_key': $j.getInfo('action'), 'width': '13.75%',
						'options': action_options
					},
					{'selector': 'block_period', 'lang_key': $j.getInfo('block_period'), 'width': '13.75%',
						'inline_type': 'number', 'validate': 'number required'
					},	  						  
					{'selector': 'severity', 'lang_key': $j.getInfo('severity'), 'width': '13.75%',
						'options': severity_options
					},  
					{'selector': 'trigger', 'lang_key': $j.getInfo('trigger_policy'), 'width': '16.25%',
						'options': trigger_options
					}				 
				];
				break;		
			default:
		}

		var settings = {
			'prefix': type,
			'columns': columns,
			'options': options,			
			'format_fn': format_fn,
			'callbacks': {
				'load': function() {
					_in_onload(type, $container);
				}
			}
		};

		var h = action_settings.handlers[type] = new QListInlineHandlers($entries,
							 {read_only: !is_rw_admin || default_flag});

		$container.qlist(h.attach(settings));
	}

	function configure() {
		// inline-table signatures will be excluded from the pattern
		// based filter list.
		action_settings.handlers = [];
		configure_action('json_action', $('#json_action_table'), $('input[name="json_action_entries"]'));

		$('form').off("submit").submit(function() {
			var result = $(this).valid()
				&& action_settings.handlers['json_action'].update_form()
			return result;
		}).validate({'onsubmit': false});

		//$('select.mlist').multiList({'min': 1});
		//$('input.ezmark').ezMark();
	}

	function disable_table (key) {
		var $checkbox = $('#'+key+'_table').find('.toggle-switch');
		$checkbox.attr('disabled',true);
		action_settings.handlers[key].config.read_only = 1;
		$('#'+key+'_table').find('.qlist_row').addClass('disabled');
	}

	function enable_table (key) {
		var $checkbox = $('#'+key+'_table').find('.toggle-switch');
		$checkbox.attr('disabled',false);
		action_settings.handlers[key].config.read_only = 0;
		$('#'+key+'_table').find('.qlist_row[can_edit="1"]').removeClass('disabled');
	}

	return {
		configure: configure,
		disable_table: disable_table,
		enable_table: enable_table
	};
})(jQuery);
