var DetailsWindow = (function($) {
    var config = {
        "containerSelector" : "#policyview-container",
        "mainPanelSelector" : "#policyview-main",
        "detailsPanelSelector" : "#policyview-details",
        "contentBodySelector" : "#policy_status-qlist",
        "contentHeadSelector" : "#policy_status-colhdr-container",
        "detailsLocation" : "south",
        "initialHidden" : "false",
        "sizeSouth" : getCookie("sizeSouth") || 180,
        "sizeEast" : getCookie("sizeEast") || 220,
        "formatCallbacks" : {},
        "rowData" : [],
        "getRowCallback" : function(row_id) { return config['rowData'][row_id]; },
        "getRowLengthCallback" : function() { return config['rowData'].length; },
        "langOverride" : {}
    };
    var busy;
    var layout;
    var detailsPanel;
    var mainPanel;
    var selectedRowEntry;
    var selectedRowEntryIndex;
    var rows = [];
    var first_row;

    function initialize(params) {
        var layout_params = [];
        var detail_loc;
        var p_size;
        var id_tmp;

        config = $.extend({}, config, params);

        mainPanel = $(config["mainPanelSelector"]);
        detailsPanel = $(config["detailsPanelSelector"]);

        if (detailsPanel.length < 1) {
            id_tmp = config["mainPanelSelector"].substr(1);
            mainPanel = appendMainPanel(id_tmp);
        }

        if (detailsPanel.length < 1) {
            id_tmp = config["detailsPanelSelector"].substr(1);
            detailsPanel = appendDetailPanel(id_tmp);
        }

        mainPanel.scroll(fixHeaderScrollPosition);
        detail_loc = getDetailPaneLocation();

        layout_params["center"] = {
                paneSelector: config["mainPanelSelector"],
                onresize_end: refreshDisplay
            };

        layout_params[detail_loc] = {
                paneSelector: config["detailsPanelSelector"],
                initHidden: config["initialHidden"],
                resizable: true,
                togglerLength_open: 0,
                togglerLength_closed: 0,
                onresize_end: function(local) {
                    // some events such as changing the panel location will trigger this, skip
                    if (busy || !layout) {
                        return;
                    }

                    var propName = "size" + local.charAt(0).toUpperCase() + local.slice(1);
                    var size = layout.state[local].size;

                    config[propName] = size;
                    setCookie(propName, size);
                    sizeDetailPane();
                }
            };

        layout = $(config["containerSelector"]).layout(layout_params);
        setMenuButton("hidden");
        rows = $("tr", config['contentBodySelector']).get();
        first_row = rows[0];

        while ($(first_row).hasClass("heading")) {
            rows.shift();
            first_row = rows[0];
        }

        if (!config["initialHidden"]) {
            setMenuButton(config[detail_loc]);

            if (rows.length > 0) {
                if(params.rowData[0])
                {
                    selectRow(rows[0]);
                }else{
                    selectRow(first_row);
                }

            }

            showRowDetailsMenu(true);
	    if(first_row == undefined || rows[0] == undefined)
		detailsPanel.empty();
        }

        busy = false;
    }

    function appendMainPanel(panel_id) {
        var html = "<div id=\"" + panel_id + "\"></div>";
        var b = $("body.main");
        
        b.wrapInner(html);

        return $(panel_id);
    }

    function appendDetailPanel(panel_id) {
        var html = $("<div id=\"" + panel_id + "\"></div>");

        return html.appendTo("body");
    }

    function sizeDetailPane() {
        var local = getDetailPaneLocation();
        var size = {
            "south" : parseInt(config["sizeSouth"]),
            "east" : parseInt(config["sizeEast"])
        }

        layout.sizePane(local, size[local]);
    }

    function refreshDisplay() {
        var bodyTable = $(config['contentBodySelector']).closest("table").get(0);
        var headerTable = $(config['contentHeadSelector']).get(0);
        var right_qlist = $("#qlist_right_menubar_container");
        var i;

        if ("east" == getDetailPaneLocation() && !layout.state["east"].isHidden) {
            right_qlist.css("marginRight", config["sizeEast"] + "px");
        } else {
            right_qlist.css("marginRight", "");
        }

        qlist_realign_floating_header();
        qlist_realign_floating_footer();

        var bottom = $(window).height() - $("#main_window")[0].clientHeight;
        $("#qlist_ftrbar").css("bottom", bottom + "px");

        tbl_realign_columns(headerTable, bodyTable);
    }

    function fixHeaderScrollPosition() {
        var header = $("#hrdtc")[0];
        var container = $("#main_window")[0];

        $(header).css("marginLeft", "-" + container.scrollLeft + "px");
    }

    function setMenuButton(local) {
        var itemClass = "qlist_marked_menu_item";

        $("#mi_detail_right").toggleClass(itemClass, local == "east");
        $("#mi_detail_bottom").toggleClass(itemClass, local == "south");
        $("#mi_detail_close").toggleClass(itemClass, local == "hidden");
    }

    function toggleDetailsPanelLocation(local) {
        var curr = getDetailPaneLocation();

        busy = true;

        if (typeof(local) == "undefined" || curr !== local) {
            layout.swapPanes("east", "south");

            if (selectedRowEntry) {
                showRowDetailsPos(getDetailPaneLocation() == "south" ? "east" : "south");
            }

            sizeDetailPane();
            refreshDisplay();
        }

        setMenuButton(local);

        busy = false;
    }
   
    function selectRow(row) {
        if (typeof row == "undefined") {
            return;
        }

        if (typeof(selectedRowEntry) != "undefined") {
            $(selectedRowEntry).toggleClass("policy_entry_selected", false);
            selectedRowEntry = null;
            selectedRowEntryIndex = 0;
        }
    	if(row.id != "tr_merge")
    	{
                // set selected entry
                selectedRowEntry = row;
		selectedRowEntryIndex = parseInt(row.getAttribute("mkey"));
		//selectedRowEntryIndex = row.rowIndex - first_row.rowIndex; //by shuyusun: Fixed bug 0566265
                $(selectedRowEntry).addClass("policy_entry_selected");
    	}
    }

    function handleRowDetailKeyPress(e) {
        var local = getDetailPaneLocation();
        var idx = selectedRowEntryIndex;
        var tr;

        if (e.keyCode != 38 && e.keyCode != 40)
            return;

        if (e.keyCode == 38)
            idx--;

        if (e.keyCode == 40)
            idx++;

        if (idx >= 0 && (tr = rows[idx])) {
            selectRow(tr);

            if (!layout.state[local].isHidden) {
                showRowDetails(tr);
            }

            return false;
        }
    }

    function showRowDetailsMenu(noFx) {
        if (selectedRowEntry == null) {
            selectRow(first_row);
        }

        if (noFx) {
            $.fx.off = true;
        }

        sizeDetailPane();
        showRowDetails();
        //updateSystemPosition(config['detailsLocation']);

        $.fx.off = false;
    }

    function showRowDetailsClick(e) {
        var target = e.target.parentNode;

        while (target) {
            if (target.tagName === "TR") {
                selectRow(target);
                sizeDetailPane();
                showRowDetails(target, e);

                break;
            }

            if (target.parentNode) {
                target = target.parentNode;
            } else {
                return false;
            }
        }

        return true;
    }

    function getDetailPaneLocation() {
        if (layout && layout.panes["east"] !== false) {
            config["detailsLocation"] = "east";
        }

        if (layout && layout.panes["south"] !== false) {
            config["detailsLocation"] = "south";
        }

        return config["detailsLocation"];
    }

    function setDetailPaneLocation(local) {
        if (local == "east" || local == "south") {
            config["detailsLocation"] = local;
        }

        return config["detailsLocation"];
    }

    function updateViewPos() {
        var icon = $("#view_pos");
        var pos = getDetailPaneLocation();
    }

    function showRowDetailsPos(pos) {
        var tr = selectedRowEntry;

        if (typeof(pos) !== "undefined") {
            setDetailPaneLocation(pos);
        }

        showRowDetails(tr);
    }

    function updateSystemPosition(pos) {
        var key = "set_detail";
        var data = {};
        var params = {
            'url': '/system/policy'
        }

        if (pos == "east") {
            data[key] = "2";
        } else if (pos == "hidden") {
            data[key] = "0";
        } else {
            data[key] = "1";
        }

        params['data'] = data;

        $.ajax(params);
    }

    function showRowDetails(tr, e) {
        var row_entry;
        var header;
        var table;
        var html_buffer;
        var local = getDetailPaneLocation();

        if (typeof(tr) == "undefined") {
            tr = selectedRowEntry;

            if (!tr) {
                return;
            }
        }
	if(tr.getAttribute("mkey") == null)
	    return;

        // decrease header row & filter row
        //row_entry = config['getRowCallback'](tr.rowIndex - first_row.rowIndex);   //by shuyusun: Fixed bug 0566265
        row_entry = config['getRowCallback'](selectedRowEntryIndex);
        table = buildTable(row_entry); 

        detailsPanel.empty().append(table);
        layout.show(config["detailsLocation"], true, true);
        setMenuButton(config["detailsLocation"]);

    }
    
    //unused
    function showRowDetailsNext() {
        var tr = ie4 ? selectedRowEntry.nextSibling : selectedRowEntry.nextSibling.nextSibling;

        if (selectedRowEntry.rowIndex >= config['getRowLengthCallback']()) {
            return;
        }

        showRowDetails(tr);
        showRowDetailsScroll(tr);
    }

    function showRowDetailsPrev() {
        var tr = ie4 ? selectedRowEntry.previousSibling : selectedRowEntry.previousSibling.previousSibling;

        if (!tr) {
            return;
        }

        showRowDetails(tr);
        showRowDetailsScroll(tr);
    }

    function showRowDetailsScroll(tr) {
        var container = $("#tableContainer");

        if ((tr.offsetTop + tr.clientHeight) > (container.scrollTop + container.clientHeight)) {
            tr.scrollIntoView(false);
        }
        else if (tr.offsetTop < container.scrollTop) {
            tr.scrollIntoView(true);
        }

        $("#policy_details").style.right = "0px";
    }

    function hideRowDetails() {
        var local = getDetailPaneLocation();

        setMenuButton("hidden");
        //updateSystemPosition("hidden");

        layout.hide(local, true);
    }

    function trigger_div(id)
    {
	    var div = document.getElementById("div_"+id);
	    var imgs = document.getElementById("imgs_"+id);
	    var imgh = document.getElementById("imgh_"+id);

	    if(!div || !imgs || !imgh)
		    return;

	    if(div.style.display == 'none')
	    {
		    div.style.display = '';
		    imgs.style.display = '';
		    imgh.style.display = 'none';
	    }
	    else
	    {
		    div.style.display = 'none';
		    imgs.style.display = 'none';
		    imgh.style.display = '';
	    }
    }
    function buildTable(row_entry)
    {
      var lang_override;
        var elems = [];
        var rows = [];
        var html;
        var label;
        var row_class, label_class;
        var width = 100;
        var obj = row_entry;
        var row_num = 0;
        var val;
        lang_override = config["langOverride"];

        var tb = document.createElement("div");
        tb.id = "policy_details_table";
        $(tb).width("100%");
        
        var date = new Date();
        var new_table_id = date.getTime();
        elems.push("<div id=\"sp_"+new_table_id+"\" style=\" overflow: auto; height: inherit; \"></div>");
       
        buildTable_sp(obj["policy"],new_table_id);
        return $(elems.join(""));    
    }

    function buildTable_sp(policy,new_table_id) {        

        function aggCallback(result){
            var html = '';
            html +="<table width=\"100%\"><tr><td style='font-size:15px;'>&nbsp;&nbsp;"+$.getInfo("total")+":"+result.total+"</td></tr></table>"; 
            html +="<table id=\"policy_status\" cellspace=\"1\" cellpadding=\"0\" class=\"list\" width=\"100%\">";

            html +="<tr class=\"heading\">";
            html +="<th width=\"5%\" nowrap=\"\">#</th>";
            html +="<th width=\"27%\" nowrap=\"\">"+$.getInfo("pool")+"</th>";
            html +="<th width=\"11%\" nowrap=\"\">"+$.getInfo("ip_domain")+"</th>";
            html +="<th width=\"5%\" nowrap=\"\">"+$.getInfo("port")+"</th>";
            if(result.deploymode !=2 && result.deploymode != 3)
            {
		    if(result.deploymode != 5)
		    {
			    html +="<th width=\"12%\" nowrap=\"\">"+$.getInfo("hc_status")+"</th>";
			    html +="<th width=\"10%\" nowrap=\"\">"+$.getInfo("session_count")+"</th>";
			    html += "<th width=\"10%\" nowrap=\"\">"+$.getInfo("backup_status")+"</th>";
		    }
            }
            html +="<th width=\"20%\" nowrap=\"\">"+$.getInfo("status")+"</th>";
            html +="</tr>";

            if(result.deploymode != 1)
            {
                var server_pool = result.server_pool;
                var sp_item = server_pool.sp_item;
                var count = 0;
                for(var i = 0 ;i < sp_item.length;i++)
                {    
                    var tr_class = ' odd';
                    if(i%2 == 0) tr_class = ' even';            
                    html += '<tr class=\"qlist_row '+tr_class+'\" id=\"'+server_pool.name+'_'+count+'\"><td>'+(count+1)+'</td>';// style=" background-color: green; "
                    html += '<td title=\"'+server_pool.name+'\">'+server_pool.name+'</td>';
                    html += '<td>'+sp_item[i].ip_domain+'</td>';
                    html += '<td>'+sp_item[i].port+'</td>';
                    if(result.deploymode !=2 && result.deploymode != 3)
                    {
			    if(result.deploymode != 5)
			    {
				    if(sp_item[i].hc_status == 1)
				    {
					    html += '<td><span><f-icon class="fa-link" style="color: #33cc00"></f-icon></span></td>';
					    //html += '<td><img src=\"/images/st_ok.gif\" width=15 height=15></td>';
				    }else if(sp_item[i].hc_status == 0)
				    {
					    html += '<td><span><f-icon class="fa-chain-broken" style="color: #ff6600"></f-icon></span></td>';
					    //html += '<td><img src=\"/images/st_na.gif\" width=15 height=15></td>';
				    }else{
					    html += '<td><span><f-icon class="ftnt-help-o" style="color: #999"></f-icon></span></td>';
					    //html += '<td><img src=\"/images/st_disable.gif\" width=15 height=15></td>';                    
				    }

				    html += '<td>'+sp_item[i].session+'</td>';

				    if(sp_item[i].backup_status == 1)
					    html += '<td>'+$.getInfo("enabled")+'</td>';
				    else
					    html += '<td>'+$.getInfo("disabled")+'</td>';
			    }
                    }

                    var status = sp_item[i].status;
                    if(server_pool.type == 1){
                        html += '<td><div><div class="switch-toggle switch-3 switch-candy yellow">';
                    }else{
                        html += '<td><div><div class="switch-toggle switch-2 switch-candy yellow">';
                    }
                    
                    html += '<input class="bare" id="enable_'+count+'" name="status_'+count+'" type="radio" disabled';
                    if(status == 1)
                    {
                        html += ' checked>';                    
                    }else{
                        html += ' >'; 
                    }

                    html += '<label for="enable_'+count+'" onclick="">'+$.getInfo("sp_enable")+'</label>';
                    html += '<input class="bare" id="disable_'+count+'" name="status_'+count+'" type="radio" disabled';
                    if(status == 0)
                    {
                        html += ' checked>';
                    }else{
                        html += ' >'; 
                    }
                    
                    html += '<label for="disable_'+count+'" onclick="">'+$.getInfo("sp_disable")+'</label>';
                    if(server_pool.type == 1)
                    {
                        html += '<input class="bare" id="maintain_'+count+'" name="status_'+count+'" type="radio" disabled';
                        if(status == 2)
                        {
                            html += ' checked>';
                        }else{
                            html += ' >'; 
                        }
                        
                        html += '<label for="maintain_'+count+'" onclick="">'+$.getInfo("sp_maintain")+'</label>';
                    }
                    html +='<a></a>'
                        +'</div></div></td>';
                    html += '</tr>'; 
                    count++;
                }

            }else if(result.deploymode == 1){
                var routing = result.routing;
                var count = 0;
                for(var j = 0;j<routing.length;j++)
                {                
                    html += '<tr class=\"qlist_category\">';
                    html += '<td colspan = 8 nowrap style="text-align: left">'
                    +'<button type="button" id=\"routing_'+j+'\"" class="compact-visual-toggle active" onclick="collpase(this)"></button></span>';
                       // +'<span id="imgh_routing_'+j+'"  style="display:none"><button src="/theme/images/twistie_collapsed.gif"></span>';
                    html += routing[j].name+'</span></td></tr>';

                    var server_pool = routing[j].server_pool;
                    var sp_item = server_pool.sp_item;
                    for(var i = 0 ;i < sp_item.length;i++)
                    { 
                        var tr_class = ' odd';
                        if(i%2 == 0) tr_class = ' even';
                        html += '<tr class=\"qlist_row '+tr_class+'\"  collpase_id=\"routing_'+j+'_sub\"><td>'+(count+1)+'</td>';// style=" background-color: green; "
                        html += '<td title=\"'+server_pool.name+'\">'+server_pool.name+'</td>';
                        html += '<td>'+sp_item[i].ip_domain+'</td>';
                        html += '<td>'+sp_item[i].port+'</td>';
                        if(sp_item[i].hc_status == 1)
                        {
				html += '<td><span><f-icon class="fa-link" style="color: #33cc00"></f-icon></span></td>';
//                            html += '<td><img src=\"/images/st_ok.gif\" width=15 height=15></td>';
                        }else if(sp_item[i].hc_status == 0)
                        {
				html += '<td><span><f-icon class="fa-chain-broken" style="color: #ff6600"></f-icon></span></td>';
//                            html += '<td><img src=\"/images/st_na.gif\" width=15 height=15></td>';
                        }else{
				html += '<td><span><f-icon class="ftnt-help-o" style="color: #999"></f-icon></span></td>';
//                            html += '<td><img src=\"/images/st_disable.gif\" width=15 height=15></td>';                    
                        }
                        html += '<td>'+sp_item[i].session+'</td>';

			if(sp_item[i].backup_status == 1)
				html += '<td>'+$.getInfo("enabled")+'</td>';
			else
				html += '<td>'+$.getInfo("disabled")+'</td>';

                        var status = sp_item[i].status;
                        if(server_pool.type == 1)
                        {
                            html += '<td><div><div class="switch-toggle switch-3 switch-candy yellow">';    
                        }else{
                            html += '<td><div><div class="switch-toggle switch-2 switch-candy yellow">';
                        }
                        
                        html += '<input class="bare" id="enable_'+count+'" name="status_'+count+'" type="radio" disabled';
                        if(status == 1)
                        {
                            html += ' checked>';                    
                        }else{
                            html += ' >'; 
                        }

                        html += '<label for="enable_'+count+'" onclick="">'+$.getInfo("sp_enable")+'</label>';
                        html += '<input class="bare" id="disable_'+count+'" name="status_'+count+'" type="radio" disabled';
                        if(status == 0)
                        {
                            html += ' checked>';
                        }else{
                            html += ' >'; 
                        }
                        
                        html += '<label for="disable_'+count+'" onclick="">'+$.getInfo("sp_disable")+'</label>';
                        if(server_pool.type == 1)
                        {
                             html += '<input class="bare" id="maintain_'+count+'" name="status_'+count+'" type="radio" disabled';
                            if(status == 2)
                            {
                                html += ' checked>';
                            }else{
                                html += ' >'; 
                            }
                            
                            html += '<label for="maintain_'+count+'" onclick="">'+$.getInfo("sp_maintain")+'</label>';                           
                        }

                            html +='<a></a>'
                            +'</div></div></td>';
                        html += '</tr>';                             
                        count++;  
                    }                
                }
            }

            html += '</table>';
            $("#sp_"+new_table_id).append(html);
        };
        var sp_url = "/system/status/policy_sp";
        var sp_data = {policy:policy};
        $.post(sp_url,sp_data,function(data){
            if(data)aggCallback(data);
        },"json"); 
    }
    return {
        "initialize" : initialize,
        "show" : showRowDetailsMenu,
        "hide" : hideRowDetails,
        "move" : toggleDetailsPanelLocation,
        "click" : showRowDetailsClick,
        "keypress" : handleRowDetailKeyPress,
        "buildtable":buildTable,
	    "trigger_div":trigger_div
    };
})(jQuery);

 function collpase(btn)
{
    var expand = change_button_icon(btn);
    if( !expand){
        $j('[collpase_id='+btn.id+'_sub]').hide();
    }else{
        $j('[collpase_id='+btn.id+'_sub]').show();
    }
}
