
var profile_inline = (function($) {
	'use strict';

	function _in_onload(type, $inline) {
		$('.ql-body-container').css('overflow', 'inherit');
		$('.toggle-switch', $inline).change(function() {
			var $parent = $(this).parents('tr');

			// Prevent disabled entries from using inline edit support.
			var can_edit = ($parent.attr('can_edit') === '1') ? '0' : '1';
			$parent.attr('can_edit', can_edit);
			if(can_edit === '1')
				$parent.removeClass('disabled');
			else
				$parent.addClass('disabled');
		});

		$inline.find('.ql-head-container').css('display','none'); 

		//if(type == 'cookie_poison' || type == 'xml_protocol' || type == 'json_protocol')
		/*
		if(type == 'xml_protocol' || type == 'json_protocol')
		{	
			// Range validation for block_period
			$('td.block_period input[type=number]',$inline).attr({
				'min': 1,
				'max': 3600
			});

			$('td.action select[data-name=action]', $inline).on('change', function() {
				var $parent = $(this).parents('tr');
				var id = $parent.attr('data-row-handler-id');

				var val = ($(this).val());
				var $block = $('td.block_period input#'+type+'-'+id+'-block_period', $inline);
				$block.attr('disabled', val === '4' ? false: true);
			});
		}*/

		$('td.block_period input', $inline).each(function(){
			var $parent = $(this).parents('tr');
			var id = $parent.attr('data-row-handler-id');
			var action = $('td.action select', $parent).val();
			$(this).attr('disabled', action === '4' ? false: true);
		});  
	}

	function configure_inline(type, $container, $entries) {
		// 'inline-mode' defaults to 'continous' and is configurable from
		// the CLI only.

		var options = {
			// List of inline-table  is resizeable.
			'hide_create_button': true,
			'hide_delete_button': true,
			'fixed_header': false,
			'css_layout': false,
			//'hide_menu': true,
		};

		var format_fn = {
			// A format function is provided to override the default
			// inline editing capabilities for this field.
			'name': function(td, column, entry) {
				return entry.name;
			},
			'status': function(td, column, entry) {
				var $parent = td.parents(), can_edit = '1';
				var html = '';
				if(entry.status !== 'no')
				{
					html +='<input type="checkbox" ' +
							   'class="toggle-switch" ' +
							   ' name="'+type+'" id="'+type+'" value="enable"';
					if (entry.status === "enable") {
						html += ' checked="checked"';
					} else {
						$parent.addClass('disabled');
						can_edit = '0';
					}				  

					$parent.attr('can_edit', can_edit);

					html += ' />';
				}
				html += '<label for=\"'+type+'\"></label>';

				return html;
			},
		};

		var action_options = {};
		var columns = [];

		switch(type)
		{
			/*case 'cookie_poison':
				action_options = options_action_cookie;
				columns = [
					{'selector': 'name', 'lang_key': $j.getInfo('name'), 'width': '30.45%'},
					{'selector': 'status', 'lang_key': $j.getInfo('status'), 'width': '13.5%'},
					{'selector': 'action', 'lang_key': $j.getInfo('action'), 'width': '13.5%',
						'options': action_options
					},  
					{'selector': 'block_period', 'lang_key': $j.getInfo('block_period'), 'width': '13.5%',
						'inline_type': 'number', 'validate': 'number required'
					},							  
					{'selector': 'severity', 'lang_key': $j.getInfo('severity'), 'width': '13.5%',
						'options': severity_options
					},  
					{'selector': 'trigger', 'lang_key': $j.getInfo('trigger_policy'), 'width': '15.55%',
						'options': trigger_options
					}				 
				];
				break;
			case 'xml_protocol':
			case 'json_protocol':
				action_options = options_action;
				columns = [
					{'selector': 'name', 'lang_key': $j.getInfo('name'), 'width': '28.75%'},
					{'selector': 'status', 'lang_key': $j.getInfo('status'), 'width': '13.75%'},
					{'selector': 'action', 'lang_key': $j.getInfo('action'), 'width': '13.75%',
						'options': action_options
					},  
					{'selector': 'block_period', 'lang_key': $j.getInfo('block_period'), 'width': '13.75%',
						'inline_type': 'number', 'validate': 'number required'
					},							  
					{'selector': 'severity', 'lang_key': $j.getInfo('severity'), 'width': '13.75%',
						'options': severity_options
					},  
					{'selector': 'trigger', 'lang_key': $j.getInfo('trigger_policy'), 'width': '16.25%',
						'options': trigger_options
					}				 
				];
				break;*/
			case 'quarant_ip':
				action_options = options_action_ip;
				columns = [
					{'selector': 'name', 'lang_key': $j.getInfo('name'), 'width': '28.5%'},
					{'selector': 'status', 'lang_key': $j.getInfo('status'), 'width': '15%'},
					{'selector': 'action', 'lang_key': $j.getInfo('action'), 'width': '15%',
						'options': action_options
					},  
					{'selector': 'severity', 'lang_key': $j.getInfo('severity'), 'width': '15%',
						'options': severity_options
					},  
					{'selector': 'trigger', 'lang_key': $j.getInfo('trigger_policy'), 'width': '26.5%',
						'options': trigger_options
					}				 
				];
				break;		
			default:
		}

		var settings = {
			'prefix': type,
			'columns': columns,
			'options': options,			
			'format_fn': format_fn,
			'callbacks': {
				'load': function() {
					_in_onload(type, $container);
				}
			}
		};
		
		var h = profile_inline.handlers[type] = new QListInlineHandlers($entries,
							 {read_only: !is_rw_admin || default_flag});

		$container.qlist(h.attach(settings));
	}

	function configure() {
		// inline-table signatures will be excluded from the pattern
		// based filter list.
		profile_inline.handlers = [];
		//configure_inline('cookie_poison', $('#cookie_poison_table'), $('input[name="cookie_poison_entries"]'));
		//configure_inline('xml_protocol', $('#xml_protocol_table'), $('input[name="xml_protocol_entries"]'));
		//configure_inline('json_protocol', $('#json_protocol_table'), $('input[name="json_protocol_entries"]'));
		configure_inline('quarant_ip', $('#quarant_ip_table'), $('input[name="quarant_ip_entries"]'));

		$('form').submit(function() {
			var result = $(this).valid()
				//&& profile_inline.handlers['cookie_poison'].update_form()
				//&& profile_inline.handlers['xml_protocol'].update_form()
				//&& profile_inline.handlers['json_protocol'].update_form()
				&& profile_inline.handlers['quarant_ip'].update_form();
			return result;
		}).validate({'onsubmit': false});

		//$('select.mlist').multiList({'min': 1});
		//$('input.ezmark').ezMark();
	}

	function disable_table (key) {
		var $checkbox = $('#'+key+'_table').find('.toggle-switch');
		$checkbox.attr('disabled',true);
		profile_inline.handlers[key].config.read_only = 1;
		$('#'+key+'_table').find('.qlist_row').addClass('disabled');
	}

	function enable_table (key) {
		var $checkbox = $('#'+key+'_table').find('.toggle-switch');
		$checkbox.attr('disabled',false);
		profile_inline.handlers[key].config.read_only = 0;
		$('#'+key+'_table').find('.qlist_row[can_edit="1"]').removeClass('disabled');
	}

	return {
		configure: configure,
		disable_table: disable_table,
		enable_table: enable_table
	};
})(jQuery);
