

var colors = ['', '#d4fbff', '#faffa5', '#ffca5c', '#f32e2b'];
var bcolors = ['', '#7bcade', '#d2ba00', '#e2a82e', '#d50000'];
var values = ['level_off', 'level_low', 'level_medium', 'level_high', 'level_critical'];

function process_slide(elem, val) {
    var jthis = $j(elem);
    jthis.children('div').css({
        'background': colors[val],
        'border-color': bcolors[val]
    });
    
    jthis.children('a').attr('title', $j.getInfo(values[val]));
    //$j('span.slider-level-disable-text', jthis).html($j.getInfo(values[val]));
    $j('span.slider-level-disable-text', jthis).toggle(val == 0);
}

function get_score_field(elem) {
    var jthis = $j(elem);
    var score_id = jthis.attr('id').replace('-slider', '-score');
    return $j('#' + score_id);
}

function setup_sliders() {
    $j('div.level-slider').slider({
        range: 'min',
        max: 4,
        slide: function(event, ui) {
            var val = ui.value;
            process_slide(this, val);
            var score_field = get_score_field(this);
            score_field.val(val);
        }
    }).each(function(n ,i) {
        var jthis = $j(this);
        var score_field = get_score_field(this);
        var val = score_field.val();
        jthis.slider("option", "value", val);
        process_slide(this, val);
    });
}

function restore_default()
{
	$j('div.level-slider').each(function(){
		var jthis = $j(this);
		var score_field = get_score_field(this);
		var def_val = jthis.attr('data-default-level');
		score_field.val(def_val);
		jthis.slider('option', 'value', def_val);
		process_slide(this, def_val);
	});

	$j('.required').each(function() {
		var jthis = $j(this);
		var def_val = jthis.attr('data-default-value');
		jthis.val(def_val);		
	});

    document.forms[0].sig.checked = true;    
    document.forms[0].hpc.checked = true;
    update_check(document.forms[0].sig,'sig-tip')
    update_check(document.forms[0].hpc,'hpc-tip')
}
